/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql;

import java.io.UnsupportedEncodingException;

class Buffer {
    byte[] buf;
    int buf_length;
    int pos;
    int send_length;
    static long NULL_LENGTH = -1L;

    Buffer(byte[] buf) {
        this.buf = buf;
        this.buf_length = buf.length;
    }

    Buffer(int size) {
        this.buf = new byte[size];
        this.buf_length = this.buf.length;
        this.pos = 4;
    }

    final void setBytes(byte[] buf) {
        this.send_length = this.buf_length;
        System.arraycopy(buf, 0, this.buf, 0, this.buf_length);
    }

    final byte readByte() {
        return this.buf[this.pos++];
    }

    final int readInt() {
        return Buffer.ub(this.buf[this.pos++]) + 256 * Buffer.ub(this.buf[this.pos++]);
    }

    final int readLongInt() {
        return Buffer.ub(this.buf[this.pos++]) + 256 * Buffer.ub(this.buf[this.pos++]) + 65536 * Buffer.ub(this.buf[this.pos++]);
    }

    final long readLong() {
        return Buffer.ub(this.buf[this.pos++]) + 256 * Buffer.ub(this.buf[this.pos++]) + 65536 * Buffer.ub(this.buf[this.pos++]) + 0x1000000 * Buffer.ub(this.buf[this.pos++]);
    }

    final long readLongLong() {
        return Buffer.ub(this.buf[this.pos++]) + (Buffer.ub(this.buf[this.pos++]) << 8) + (Buffer.ub(this.buf[this.pos++]) << 16) + (Buffer.ub(this.buf[this.pos++]) << 24) + (Buffer.ub(this.buf[this.pos++]) + (Buffer.ub(this.buf[this.pos++]) << 8) + (Buffer.ub(this.buf[this.pos++]) << 16) + (Buffer.ub(this.buf[this.pos++]) << 24) << 32);
    }

    final int readnBytes() {
        switch (Buffer.ub(this.buf[this.pos++])) {
            case 1: {
                return Buffer.ub(this.buf[this.pos++]);
            }
            case 2: {
                return this.readInt();
            }
            case 3: {
                return this.readLongInt();
            }
            case 4: {
                return (int)this.readLong();
            }
        }
        return 255;
    }

    final long readLength() {
        switch (Buffer.ub(this.buf[this.pos])) {
            case 251: {
                ++this.pos;
                return 0L;
            }
            case 252: {
                ++this.pos;
                return this.readInt();
            }
            case 253: {
                ++this.pos;
                return this.readLongInt();
            }
            case 254: {
                ++this.pos;
                return this.readLong();
            }
        }
        return Buffer.ub(this.buf[this.pos++]);
    }

    final long newReadLength() {
        switch (Buffer.ub(this.buf[this.pos])) {
            case 251: {
                ++this.pos;
                return 0L;
            }
            case 252: {
                ++this.pos;
                return this.readInt();
            }
            case 253: {
                ++this.pos;
                return this.readLongInt();
            }
            case 254: {
                ++this.pos;
                return this.readLongLong();
            }
        }
        return Buffer.ub(this.buf[this.pos++]);
    }

    final long readFieldLength() {
        switch (Buffer.ub(this.buf[this.pos])) {
            case 251: {
                ++this.pos;
                return NULL_LENGTH;
            }
            case 252: {
                ++this.pos;
                return this.readInt();
            }
            case 253: {
                ++this.pos;
                return this.readLongInt();
            }
            case 254: {
                ++this.pos;
                return this.readLong();
            }
        }
        return Buffer.ub(this.buf[this.pos++]);
    }

    final byte[] readByteArray() {
        return this.getNullTerminatedBytes();
    }

    final byte[] readLenByteArray() {
        long len = this.readFieldLength();
        if (len == NULL_LENGTH) {
            return null;
        }
        if (len == 0L) {
            return new byte[0];
        }
        return this.getBytes((int)len);
    }

    final String readString() {
        int i = this.pos;
        int len = 0;
        while (this.buf[i] != 0 && i < this.buf_length) {
            ++len;
            ++i;
        }
        String S = new String(this.buf, this.pos, len);
        this.pos += len + 1;
        return S;
    }

    final String readLenString() {
        long len = this.readFieldLength();
        if (len == NULL_LENGTH) {
            return null;
        }
        if (len == 0L) {
            return "";
        }
        String S = new String(this.buf, this.pos, (int)len);
        this.pos = (int)((long)this.pos + len);
        return S;
    }

    final byte[] getBytes(int len) {
        byte[] b = new byte[len];
        System.arraycopy(this.buf, this.pos, b, 0, len);
        this.pos += len;
        return b;
    }

    final byte[] getNullTerminatedBytes() {
        int i = this.pos;
        int len = 0;
        while (this.buf[i] != 0 && i < this.buf_length) {
            ++len;
            ++i;
        }
        byte[] b = new byte[len];
        System.arraycopy(this.buf, this.pos, b, 0, len);
        this.pos += len + 1;
        return b;
    }

    final boolean isLastDataPacket() {
        return this.buf_length <= 2 && Buffer.ub(this.buf[0]) == 254;
    }

    final void clear() {
        this.pos = 4;
    }

    final void writeByte(byte b) {
        this.buf[this.pos++] = b;
    }

    final void writeInt(int i) {
        int r = i % 256;
        this.buf[this.pos++] = (byte)r;
        this.buf[this.pos++] = (byte)(i /= 256);
    }

    final void writeLongInt(int i) {
        int r = i % 256;
        this.buf[this.pos++] = (byte)r;
        r = (i /= 256) % 256;
        this.buf[this.pos++] = (byte)r;
        this.buf[this.pos++] = (byte)(i /= 256);
    }

    final void writeLong(long i) {
        long r = i % 256L;
        this.buf[this.pos++] = (byte)r;
        r = (i /= 256L) % 256L;
        this.buf[this.pos++] = (byte)r;
        r = (i /= 256L) % 256L;
        this.buf[this.pos++] = (byte)r;
        this.buf[this.pos++] = (byte)(i /= 256L);
    }

    final void writeString(String S) {
        this.writeStringNoNull(S);
        this.buf[this.pos++] = 0;
    }

    final void writeStringNoNull(String S) {
        byte[] b = S.getBytes();
        int len = b.length;
        System.arraycopy(b, 0, this.buf, this.pos, len);
        this.pos += len;
    }

    final void writeStringNoNull(String S, String Encoding) throws UnsupportedEncodingException {
        byte[] b = S.getBytes(Encoding);
        int len = b.length;
        System.arraycopy(b, 0, this.buf, this.pos, len);
        this.pos += len;
    }

    final void writeBytesNoNull(byte[] Bytes) {
        int len = Bytes.length;
        System.arraycopy(Bytes, 0, this.buf, this.pos, len);
        this.pos += len;
    }

    static final int ub(byte b) {
        return b < 0 ? 256 + b : b;
    }

    final void dump() {
        int p = 0;
        int rows = this.buf_length / 8;
        int i = 0;
        while (i < rows) {
            int ptemp = p;
            int j = 0;
            while (j < 8) {
                String HexVal = Integer.toHexString(this.buf[ptemp]);
                if (HexVal.length() == 1) {
                    HexVal = "0" + HexVal;
                }
                System.out.print(String.valueOf(HexVal) + " ");
                ++ptemp;
                ++j;
            }
            System.out.print("    ");
            int j2 = 0;
            while (j2 < 8) {
                if (this.buf[p] > 32 && this.buf[p] < 127) {
                    System.out.print(String.valueOf((char)this.buf[p]) + " ");
                } else {
                    System.out.print(". ");
                }
                ++p;
                ++j2;
            }
            System.out.println();
            ++i;
        }
        int n = 0;
        int i2 = p;
        while (i2 < this.buf_length) {
            String HexVal = Integer.toHexString(this.buf[i2]);
            if (HexVal.length() == 1) {
                HexVal = "0" + HexVal;
            }
            System.out.print(String.valueOf(HexVal) + " ");
            ++n;
            ++i2;
        }
        int i3 = n;
        while (i3 < 8) {
            System.out.print("   ");
            ++i3;
        }
        System.out.print("    ");
        int i4 = p;
        while (i4 < this.buf_length) {
            if (this.buf[i4] > 32 && this.buf[i4] < 127) {
                System.out.print(String.valueOf((char)this.buf[i4]) + " ");
            } else {
                System.out.print(". ");
            }
            ++i4;
        }
        System.out.println();
    }
}

