/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.gjt.mm.mysql.Connection;
import org.gjt.mm.mysql.Field;
import org.gjt.mm.mysql.MysqlDefs;
import org.gjt.mm.mysql.MysqlIO;
import org.gjt.mm.mysql.ResultSet;

public class DatabaseMetaData
implements java.sql.DatabaseMetaData {
    private Connection _Conn;
    private String _Database;
    private static byte[] _Table_As_Bytes = new byte[]{84, 65, 66, 76, 69};

    public DatabaseMetaData(Connection Conn, String Database) {
        this._Conn = Conn;
        this._Database = Database;
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return false;
    }

    public String getURL() throws SQLException {
        return new String(this._Conn.getURL());
    }

    public String getUserName() throws SQLException {
        return new String(this._Conn.getUser());
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return !this.nullsAreSortedHigh();
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public String getDatabaseProductName() throws SQLException {
        return "MySQL";
    }

    public String getDatabaseProductVersion() throws SQLException {
        return new String(this._Conn.getServerVersion());
    }

    public String getDriverName() throws SQLException {
        return "Mark Matthews' MySQL Driver";
    }

    public String getDriverVersion() throws SQLException {
        return "1.2b";
    }

    public int getDriverMajorVersion() {
        return 1;
    }

    public int getDriverMinorVersion() {
        return 2;
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public String getIdentifierQuoteString() throws SQLException {
        return " ";
    }

    public String getSQLKeywords() throws SQLException {
        return "AUTO_INCREMENT,BINARY,BLOB,ENUM,INFILE,LOAD,MEDIUMINT,OPTION,OUTFILE,REPLACE,SET,TEXT,UNSIGNED,ZEROFILL";
    }

    public String getNumericFunctions() throws SQLException {
        return "ABS,ACOS,ASIN,ATAN,ATAN2,BIT_COUNT,CEILING,COS,COT,DEGREES,EXP,FLOOR,LOG,LOG10,MAX,MIN,MOD,PI,POW,POWER,RADIANS,RAND,ROUND,SIN,SQRT,TAN,TRUNCATE";
    }

    public String getStringFunctions() throws SQLException {
        return "ACII,CHAR,CHAR_LENGTH,CHARACTER_LENGTH,CONCAT,ELT,FIELD,FIND_IN_SET,INSERT,INSTR,INTERVAL,LCASE,LEFT,LENGTH,LOCATE,LOWER,LTRIM,MID,POSITION,OCTET_LENGTH,REPEAT,REPLACE,REVERSE,RIGHT,RTRIM,SPACE,SOUNDEX,SUBSTRING,SUBSTRING_INDEX,TRIM,UCASE,UPPER";
    }

    public String getSystemFunctions() throws SQLException {
        return "DATABASE,USER,SYSTEM_USER,SESSION_USER,PASSWORD,ENCRYPT,LAST_INSERT_ID,VERSION";
    }

    public String getTimeDateFunctions() throws SQLException {
        return "DAYOFWEEK,WEEKDAY,DAYOFMONTH,DAYOFYEAR,MONTH,DAYNAME,MONTHNAME,QUARTER,WEEK,YEAR,HOUR,MINUTE,SECOND,PERIOD_ADD,PERIOD_DIFF,TO_DAYS,FROM_DAYS,DATE_FORMAT,TIME_FORMAT,CURDATE,CURRENT_DATE,CURTIME,CURRENT_TIME,NOW,SYSDATE,CURRENT_TIMESTAMP,UNIX_TIMESTAMP,FROM_UNIXTIME,SEC_TO_TIME,TIME_TO_SEC";
    }

    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return false;
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        switch (fromType) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                switch (toType) {
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 1111: {
                        return true;
                    }
                }
                return false;
            }
            case -7: {
                return false;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                switch (toType) {
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 0: {
                return false;
            }
            case 1111: {
                switch (toType) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 91: {
                switch (toType) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 92: {
                switch (toType) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 93: {
                switch (toType) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 91: 
                    case 92: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public String getSchemaTerm() throws SQLException {
        return "";
    }

    public String getProcedureTerm() throws SQLException {
        return "";
    }

    public String getCatalogTerm() throws SQLException {
        return "database";
    }

    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        if (this._Conn.getServerMajorVersion() >= 3) {
            if (this._Conn.getServerMajorVersion() == 3) {
                return this._Conn.getServerMinorVersion() >= 22;
            }
            return true;
        }
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return false;
    }

    public boolean supportsUnion() throws SQLException {
        return false;
    }

    public boolean supportsUnionAll() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0xFFFFF8;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 0xFFFFF8;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 32;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 16;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 16;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 16;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 256;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 512;
    }

    public int getMaxConnections() throws SQLException {
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 64;
    }

    public int getMaxIndexLength() throws SQLException {
        return 128;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 32;
    }

    public int getMaxRowSize() throws SQLException {
        return 0x7FFFFFF7;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    public int getMaxStatementLength() throws SQLException {
        return MysqlIO.MAXBUF - 4;
    }

    public int getMaxStatements() throws SQLException {
        return 0;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 32;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 256;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 16;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    public boolean supportsTransactions() throws SQLException {
        return false;
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return false;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    public java.sql.ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        Field[] Fields = new Field[]{new Field("", "PROCEDURE_CAT", 1, 0), new Field("", "PROCEDURE_SCHEM", 1, 0), new Field("", "PROCEDURE_NAME", 1, 0), new Field("", "resTABLE_CAT", 1, 0), new Field("", "resTABLE_CAT", 1, 0), new Field("", "resTABLE_CAT", 1, 0), new Field("", "REMARKS", 1, 0), new Field("", "PROCEDURE_TYPE", 5, 0)};
        return new ResultSet(Fields, new Vector(), this._Conn);
    }

    public java.sql.ResultSet getProcedureColumns(String Catalog, String SchemaPattern, String ProcedureNamePattern, String ColumnNamePattern) throws SQLException {
        Field[] Fields = new Field[]{new Field("", "TABLE_CAT", 1, 0), new Field("", "PROCEDURE_CAT", 1, 0), new Field("", "PROCEDURE_SCHEM", 1, 0), new Field("", "PROCEDURE_NAME", 1, 0), new Field("", "COLUMN_NAME", 1, 0), new Field("", "COLUMN_TYPE", 1, 0), new Field("", "DATA_TYPE", 5, 0), new Field("", "TYPE_NAME", 1, 0), new Field("", "PRECISION", 4, 0), new Field("", "LENGTH", 4, 0), new Field("", "SCALE", 5, 0), new Field("", "RADIX", 5, 0), new Field("", "NULLABLE", 5, 0), new Field("", "REMARKS", 1, 0)};
        return new ResultSet(Fields, new Vector(), this._Conn);
    }

    public java.sql.ResultSet getTables(String Catalog, String SchemaPattern, String TableNamePattern, String[] Types) throws SQLException {
        String DB_Sub = "";
        if (Catalog != null) {
            if (!Catalog.equals("")) {
                DB_Sub = " FROM " + Catalog;
            }
        } else {
            DB_Sub = " FROM " + this._Database;
        }
        if (TableNamePattern == null) {
            TableNamePattern = "%";
        }
        java.sql.ResultSet RS = this._Conn.createStatement().executeQuery("show tables " + DB_Sub + " like '" + TableNamePattern + "'");
        ResultSetMetaData RsMd = RS.getMetaData();
        Field[] Fields = new Field[]{new Field("", "TABLE_CAT", 12, Catalog == null ? 0 : Catalog.length()), new Field("", "TABLE_SCHEM", 12, 0), new Field("", "TABLE_NAME", 12, 255), new Field("", "TABLE_TYPE", 12, 5), new Field("", "REMARKS", 12, 0)};
        Vector<byte[][]> Tuples = new Vector<byte[][]>();
        byte[][] Row = null;
        while (RS.next()) {
            String Name = RS.getString(1);
            Row = new byte[][]{Catalog == null ? new byte[]{} : Catalog.getBytes(), new byte[0], Name.getBytes(), _Table_As_Bytes, new byte[0]};
            Tuples.addElement(Row);
        }
        ResultSet Results = new ResultSet(Fields, Tuples, this._Conn);
        return Results;
    }

    public java.sql.ResultSet getSchemas() throws SQLException {
        Field[] Fields = new Field[]{new Field("", "TABLE_SCHEM", 1, 0)};
        Vector Tuples = new Vector();
        ResultSet RS = new ResultSet(Fields, Tuples, this._Conn);
        return RS;
    }

    public java.sql.ResultSet getCatalogs() throws SQLException {
        java.sql.ResultSet RS = this._Conn.createStatement().executeQuery("SHOW DATABASES");
        ResultSetMetaData RSMD = RS.getMetaData();
        Field[] Fields = new Field[]{new Field("", "TABLE_CAT", 12, RSMD.getColumnDisplaySize(1))};
        Vector<byte[][]> Tuples = new Vector<byte[][]>();
        while (RS.next()) {
            byte[][] RowVal = new byte[][]{RS.getBytes(1)};
            Tuples.addElement(RowVal);
        }
        return new ResultSet(Fields, Tuples, this._Conn);
    }

    public java.sql.ResultSet getTableTypes() throws SQLException {
        Vector<byte[][]> Tuples = new Vector<byte[][]>();
        Field[] Fields = new Field[]{new Field("", "TABLE_TYPE", 12, 5)};
        byte[][] TType = new byte[][]{_Table_As_Bytes};
        Tuples.addElement(TType);
        return new ResultSet(Fields, Tuples, this._Conn);
    }

    public java.sql.ResultSet getColumns(String Catalog, String SchemaPattern, String TableName, String ColumnNamePattern) throws SQLException {
        String DB_Sub = "";
        if (ColumnNamePattern == null) {
            ColumnNamePattern = "%";
        }
        if (Catalog != null) {
            if (!Catalog.equals("")) {
                DB_Sub = " FROM " + Catalog;
            }
        } else {
            DB_Sub = " FROM " + this._Database;
        }
        Vector<String> TableNameList = new Vector<String>();
        int tablename_length = 0;
        if (TableName == null) {
            java.sql.ResultSet Tables = this.getTables(Catalog, SchemaPattern, "%", new String[0]);
            while (Tables.next()) {
                String TN = Tables.getString("TABLE_NAME");
                TableNameList.addElement(TN);
                if (TN.length() <= tablename_length) continue;
                tablename_length = TN.length();
            }
            Tables.close();
        } else {
            TableNameList.addElement(TableName);
            tablename_length = TableName.length();
        }
        int catalog_length = 0;
        if (Catalog != null) {
            catalog_length = Catalog.length();
        }
        Enumeration TableNames = TableNameList.elements();
        Field[] Fields = new Field[]{new Field("", "TABLE_CAT", 1, catalog_length), new Field("", "TABLE_SCHEM", 1, 0), new Field("", "TABLE_NAME", 1, tablename_length), new Field("", "COLUMN_NAME", 1, 32), new Field("", "DATA_TYPE", 5, 5), new Field("", "TYPE_NAME", 1, 16), new Field("", "COLUMN_SIZE", 4, Integer.toString(Integer.MAX_VALUE).length()), new Field("", "BUFFER_LENGTH", 4, 10), new Field("", "DECIMAL_DIGITS", 4, 10), new Field("", "NUM_PREC_RADIX", 4, 10), new Field("", "NULLABLE", 4, 10), new Field("", "REMARKS", 1, 0), new Field("", "COLUMN_DEF", 1, 0), new Field("", "SQL_DATA_TYPE", 4, 10), new Field("", "SQL_DATETIME_SUB", 4, 10), new Field("", "CHAR_OCTET_LENGTH", 4, Integer.toString(Integer.MAX_VALUE).length()), new Field("", "ORDINAL_POSITION", 4, 10), new Field("", "IS_NULLABLE", 1, 3)};
        Vector<byte[][]> Tuples = new Vector<byte[][]>();
        while (TableNames.hasMoreElements()) {
            String TableNamePattern = (String)TableNames.nextElement();
            ResultSet RS = this._Conn.execSQL("show columns from " + TableNamePattern + DB_Sub + " like '" + ColumnNamePattern + "'", -1);
            RS.setConnection(this._Conn);
            ResultSetMetaData RSMD = RS.getMetaData();
            int ord_pos = 1;
            if (Catalog == null) {
                Catalog = "";
            }
            if (TableName == null) {
                TableName = "";
            }
            while (RS.next()) {
                byte[][] RowVal = new byte[18][];
                RowVal[0] = Catalog.getBytes();
                RowVal[1] = new byte[0];
                RowVal[2] = TableName.getBytes();
                RowVal[3] = RS.getBytes("Field");
                String TypeInfo = RS.getString("Type");
                String MysqlType = "";
                MysqlType = TypeInfo.indexOf("(") != -1 ? TypeInfo.substring(0, TypeInfo.indexOf("(")) : TypeInfo;
                RowVal[4] = Integer.toString(MysqlDefs.mysqlToJavaType(MysqlType)).getBytes();
                RowVal[5] = MysqlType.getBytes();
                if (TypeInfo != null) {
                    String Size;
                    if (TypeInfo.indexOf("enum") != -1) {
                        String Temp = TypeInfo.substring(TypeInfo.indexOf("("), TypeInfo.indexOf(")"));
                        StringTokenizer ST = new StringTokenizer(Temp, ",");
                        int max_length = 0;
                        while (ST.hasMoreTokens()) {
                            max_length = Math.max(max_length, ST.nextToken().length() - 2);
                        }
                        RowVal[6] = Integer.toString(max_length).getBytes();
                        RowVal[8] = new byte[]{48};
                    } else if (TypeInfo.indexOf(",") != -1) {
                        Size = TypeInfo.substring(TypeInfo.indexOf("(") + 1, TypeInfo.indexOf(","));
                        String Decimals = TypeInfo.substring(TypeInfo.indexOf(",") + 1, TypeInfo.indexOf(")"));
                        RowVal[6] = Size.getBytes();
                        RowVal[8] = Decimals.getBytes();
                    } else {
                        Size = "0";
                        if (TypeInfo.indexOf("(") != -1) {
                            Size = TypeInfo.substring(TypeInfo.indexOf("(") + 1, TypeInfo.indexOf(")"));
                        } else if (TypeInfo.toLowerCase().equals("tinyint")) {
                            Size = "1";
                        } else if (TypeInfo.toLowerCase().equals("smallint")) {
                            Size = "6";
                        } else if (TypeInfo.toLowerCase().equals("mediumint")) {
                            Size = "6";
                        } else if (TypeInfo.toLowerCase().equals("int")) {
                            Size = "11";
                        } else if (TypeInfo.toLowerCase().equals("integer")) {
                            Size = "11";
                        } else if (TypeInfo.toLowerCase().equals("bigint")) {
                            Size = "25";
                        } else if (TypeInfo.toLowerCase().equals("int24")) {
                            Size = "25";
                        } else if (TypeInfo.toLowerCase().equals("real")) {
                            Size = "12";
                        } else if (TypeInfo.toLowerCase().equals("float")) {
                            Size = "12";
                        } else if (TypeInfo.toLowerCase().equals("decimal")) {
                            Size = "12";
                        } else if (TypeInfo.toLowerCase().equals("numeric")) {
                            Size = "12";
                        } else if (TypeInfo.toLowerCase().equals("double")) {
                            Size = "22";
                        } else if (TypeInfo.toLowerCase().equals("char")) {
                            Size = "1";
                        } else if (TypeInfo.toLowerCase().equals("varchar")) {
                            Size = "255";
                        } else if (TypeInfo.toLowerCase().equals("date")) {
                            Size = "10";
                        } else if (TypeInfo.toLowerCase().equals("time")) {
                            Size = "8";
                        } else if (TypeInfo.toLowerCase().equals("timestamp")) {
                            Size = "19";
                        } else if (TypeInfo.toLowerCase().equals("datetime")) {
                            Size = "19";
                        } else if (TypeInfo.toLowerCase().equals("tinyblob")) {
                            Size = "255";
                        } else if (TypeInfo.toLowerCase().equals("blob")) {
                            Size = Integer.toString(Math.min(65535, MysqlIO.getMaxBuf()));
                        } else if (TypeInfo.toLowerCase().equals("mediumblob")) {
                            Size = Integer.toString(Math.min(16277215, MysqlIO.getMaxBuf()));
                        } else if (TypeInfo.toLowerCase().equals("longblob")) {
                            Size = Integer.toString(MysqlIO.getMaxBuf()).compareTo("2147483657") < 0 ? Integer.toString(MysqlIO.getMaxBuf()) : "2147483657";
                        } else if (TypeInfo.toLowerCase().equals("tinytext")) {
                            Size = "255";
                        } else if (TypeInfo.toLowerCase().equals("text")) {
                            Size = "65535";
                        } else if (TypeInfo.toLowerCase().equals("mediumtext")) {
                            Size = Integer.toString(Math.min(16277215, MysqlIO.getMaxBuf()));
                        } else if (TypeInfo.toLowerCase().equals("enum")) {
                            Size = "255";
                        } else if (TypeInfo.toLowerCase().equals("set")) {
                            Size = "255";
                        }
                        RowVal[6] = Size.getBytes();
                        RowVal[8] = new byte[]{48};
                    }
                } else {
                    RowVal[8] = new byte[]{48};
                    RowVal[6] = new byte[]{48};
                }
                RowVal[7] = Integer.toString(MysqlIO.MAXBUF).getBytes();
                RowVal[9] = new byte[]{49, 48};
                String Nullable = RS.getString("Null");
                if (Nullable != null) {
                    if (Nullable.equals("YES")) {
                        RowVal[10] = Integer.toString(1).getBytes();
                        RowVal[17] = new String("YES").getBytes();
                    } else {
                        RowVal[10] = Integer.toString(0).getBytes();
                        RowVal[17] = new String("NO").getBytes();
                    }
                } else {
                    RowVal[10] = Integer.toString(0).getBytes();
                    RowVal[17] = new String("NO").getBytes();
                }
                RowVal[11] = new byte[0];
                byte[] Default = RS.getBytes("Default");
                RowVal[12] = Default != null ? Default : new byte[0];
                RowVal[13] = new byte[]{48};
                RowVal[14] = new byte[]{48};
                RowVal[15] = RowVal[6];
                RowVal[16] = Integer.toString(ord_pos++).getBytes();
                Tuples.addElement(RowVal);
            }
            RS.close();
        }
        ResultSet Results = new ResultSet(Fields, Tuples, this._Conn);
        return Results;
    }

    public java.sql.ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        Field[] Fields = new Field[]{new Field("", "TABLE_CAT", 1, 1), new Field("", "TABLE_SCHEM", 1, 1), new Field("", "TABLE_NAME", 1, 1), new Field("", "COLUMN_NAME", 1, 1), new Field("", "GRANTOR", 1, 1), new Field("", "GRANTEE", 1, 1), new Field("", "PRIVILEGE", 1, 1), new Field("", "IS_GRANTABLE", 1, 1)};
        return new ResultSet(Fields, new Vector(), this._Conn);
    }

    public java.sql.ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        Field[] Fields = new Field[]{new Field("", "TABLE_CAT", 1, 1), new Field("", "TABLE_SCHEM", 1, 1), new Field("", "TABLE_NAME", 1, 1), new Field("", "COLUMN_NAME", 1, 1), new Field("", "GRANTOR", 1, 1), new Field("", "GRANTEE", 1, 1), new Field("", "PRIVILEGE", 1, 1), new Field("", "IS_GRANTABLE", 1, 1)};
        return new ResultSet(Fields, new Vector(), this._Conn);
    }

    public java.sql.ResultSet getBestRowIdentifier(String Catalog, String Schema, String Table, int scope, boolean nullable) throws SQLException {
        Field[] Fields = new Field[]{new Field("", "SCOPE", 5, 5), new Field("", "COLUMN_NAME", 1, 32), new Field("", "DATA_TYPE", 5, 32), new Field("", "TYPE_NAME", 1, 32), new Field("", "COLUMN_SIZE", 4, 10), new Field("", "BUFFER_LENGTH", 4, 10), new Field("", "DECIMAL_DIGITS", 4, 10), new Field("", "PSEUDO_COLUMN", 5, 5)};
        String DB_Sub = "";
        if (Catalog != null) {
            if (!Catalog.equals("")) {
                DB_Sub = " FROM " + Catalog;
            }
        } else {
            DB_Sub = " FROM " + this._Database;
        }
        if (Table == null) {
            throw new SQLException("Table not specified.", "S1009");
        }
        ResultSet RS = this._Conn.execSQL("show columns from " + Table + DB_Sub, -1);
        RS.setConnection(this._Conn);
        Vector<byte[][]> Tuples = new Vector<byte[][]>();
        while (RS.next()) {
            String KeyType = RS.getString("Key");
            if (KeyType == null || !KeyType.equals("PRI")) continue;
            byte[][] Tuple = new byte[8][];
            Tuple[0] = Integer.toString(2).getBytes();
            Tuple[1] = RS.getBytes("Field");
            String Type2 = RS.getString("Type");
            int size = MysqlIO.getMaxBuf();
            int decimals = 0;
            if (Type2.indexOf("enum") != -1) {
                String Temp = Type2.substring(Type2.indexOf("("), Type2.indexOf(")"));
                StringTokenizer ST = new StringTokenizer(Temp, ",");
                int max_length = 0;
                while (ST.hasMoreTokens()) {
                    max_length = Math.max(max_length, ST.nextToken().length() - 2);
                }
                size = max_length;
                decimals = 0;
                Type2 = "enum";
            } else if (Type2.indexOf("(") != -1) {
                if (Type2.indexOf(",") != -1) {
                    size = Integer.parseInt(Type2.substring(Type2.indexOf("(") + 1, Type2.indexOf(",")));
                    decimals = Integer.parseInt(Type2.substring(Type2.indexOf(",") + 1, Type2.indexOf(")")));
                } else {
                    size = Integer.parseInt(Type2.substring(Type2.indexOf("(") + 1, Type2.indexOf(")")));
                }
                Type2 = Type2.substring(Type2.indexOf("("));
            }
            Tuple[2] = new byte[0];
            Tuple[3] = Type2.getBytes();
            Tuple[4] = Integer.toString(size + decimals).getBytes();
            Tuple[5] = Integer.toString(size + decimals).getBytes();
            Tuple[6] = Integer.toString(decimals).getBytes();
            Tuple[7] = Integer.toString(1).getBytes();
            Tuples.addElement(Tuple);
        }
        return new ResultSet(Fields, Tuples, this._Conn);
    }

    public java.sql.ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        Field[] Fields = new Field[]{new Field("", "SCOPE", 5, 5), new Field("", "COLUMN_NAME", 1, 32), new Field("", "DATA_TYPE", 5, 5), new Field("", "TYPE_NAME", 1, 16), new Field("", "COLUMN_SIZE", 1, 16), new Field("", "BUFFER_LENGTH", 1, 16), new Field("", "DECIMAL_DIGITS", 1, 16), new Field("", "PSEUDO_COLUMN", 5, 5)};
        return new ResultSet(Fields, new Vector(), this._Conn);
    }

    public java.sql.ResultSet getPrimaryKeys(String Catalog, String Schema, String Table) throws SQLException {
        Field[] Fields = new Field[]{new Field("", "TABLE_CAT", 1, 255), new Field("", "TABLE_SCHEM", 1, 0), new Field("", "TABLE_NAME", 1, 255), new Field("", "COLUMN_NAME", 1, 32), new Field("", "KEY_SEQ", 5, 5), new Field("", "PK_NAME", 1, 32)};
        String DB_Sub = "";
        if (Catalog != null) {
            if (!Catalog.equals("")) {
                DB_Sub = " FROM " + Catalog;
            }
        } else {
            DB_Sub = " FROM " + this._Database;
        }
        if (Table == null) {
            throw new SQLException("Table not specified.", "S1009");
        }
        ResultSet RS = this._Conn.execSQL("show columns from " + Table + DB_Sub, -1);
        RS.setConnection(this._Conn);
        Vector<byte[][]> Tuples = new Vector<byte[][]>();
        while (RS.next()) {
            String KeyType = RS.getString("Key");
            if (KeyType == null || !KeyType.equals("PRI")) continue;
            byte[][] Tuple = new byte[][]{Catalog == null ? new byte[]{} : Catalog.getBytes(), new byte[0], Table.getBytes(), RS.getBytes("Field"), this.s2b("0"), RS.getBytes("Field")};
            Tuples.addElement(Tuple);
        }
        return new ResultSet(Fields, Tuples, this._Conn);
    }

    public java.sql.ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        Field[] Fields = new Field[]{new Field("", "PKTABLE_CAT", 1, 1), new Field("", "PKTABLE_SCHEM", 1, 1), new Field("", "PKTABLE_NAME", 1, 1), new Field("", "PKCOLUMN_NAME", 1, 1), new Field("", "FKTABLE_CAT", 1, 1), new Field("", "FKTABLE_SCHEM", 1, 1), new Field("", "FKTABLE_NAME", 1, 1), new Field("", "FKCOLUMN_NAME", 1, 1), new Field("", "KEY_SEQ", 5, 1), new Field("", "UPDATE_RULE", 5, 1), new Field("", "DELETE_RULE", 5, 1), new Field("", "FK_NAME", 1, 1), new Field("", "PK_NAME", 1, 1)};
        return new ResultSet(Fields, new Vector(), this._Conn);
    }

    public java.sql.ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        Field[] Fields = new Field[]{new Field("", "PKTABLE_CAT", 1, 1), new Field("", "PKTABLE_SCHEM", 1, 1), new Field("", "PKTABLE_NAME", 1, 1), new Field("", "PKCOLUMN_NAME", 1, 1), new Field("", "FKTABLE_CAT", 1, 1), new Field("", "FKTABLE_SCHEM", 1, 1), new Field("", "FKTABLE_NAME", 1, 1), new Field("", "FKCOLUMN_NAME", 1, 1), new Field("", "KEY_SEQ", 5, 1), new Field("", "UPDATE_RULE", 5, 1), new Field("", "DELETE_RULE", 5, 1), new Field("", "FK_NAME", 1, 1), new Field("", "PK_NAME", 1, 1)};
        return new ResultSet(Fields, new Vector(), this._Conn);
    }

    public java.sql.ResultSet getCrossReference(String PrimaryCatalog, String PrimarySchema, String PrimaryTable, String ForeignCatalog, String ForeignSchema, String ForeignTable) throws SQLException {
        Field[] Fields = new Field[]{new Field("", "PKTABLE_CAT", 1, 1), new Field("", "PKTABLE_SCHEM", 1, 1), new Field("", "PKTABLE_NAME", 1, 1), new Field("", "PKCOLUMN_NAME", 1, 1), new Field("", "FKTABLE_CAT", 1, 1), new Field("", "FKTABLE_SCHEM", 1, 1), new Field("", "FKTABLE_NAME", 1, 1), new Field("", "FKCOLUMN_NAME", 1, 1), new Field("", "KEY_SEQ", 5, 1), new Field("", "UPDATE_RULE", 5, 1), new Field("", "DELETE_RULE", 5, 1), new Field("", "FK_NAME", 1, 1), new Field("", "PK_NAME", 1, 1)};
        return new ResultSet(Fields, new Vector(), this._Conn);
    }

    public java.sql.ResultSet getTypeInfo() throws SQLException {
        Field[] Fields = new Field[]{new Field("", "TYPE_NAME", 1, 32), new Field("", "DATA_TYPE", 5, 5), new Field("", "PRECISION", 4, 10), new Field("", "LITERAL_PREFIX", 1, 4), new Field("", "LITERAL_SUFFIX", 1, 4), new Field("", "CREATE_PARAMS", 1, 32), new Field("", "NULLABLE", 5, 5), new Field("", "CASE_SENSITIVE", 1, 3), new Field("", "SEARCHABLE", 5, 3), new Field("", "UNSIGNED_ATTRIBUTE", 1, 3), new Field("", "FIXED_PREC_SCALE", 1, 3), new Field("", "AUTO_INCREMENT", 1, 3), new Field("", "LOCAL_TYPE_NAME", 1, 32), new Field("", "MINIMUM_SCALE", 5, 5), new Field("", "MAXIMUM_SCALE", 5, 5), new Field("", "SQL_DATA_TYPE", 4, 10), new Field("", "SQL_DATETIME_SUB", 4, 10), new Field("", "NUM_PREC_RADIX", 4, 10)};
        byte[][] RowVal = null;
        Vector<byte[][]> Tuples = new Vector<byte[][]>();
        RowVal = new byte[][]{this.s2b("TINYINT"), Integer.toString(-6).getBytes(), this.s2b("3"), this.s2b(""), this.s2b(""), this.s2b("(M) UNSIGNED ZEROFILL"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("true"), this.s2b("false"), this.s2b("true"), this.s2b("TINYINT"), this.s2b("0"), this.s2b("0"), this.s2b(""), this.s2b(""), this.s2b("10")};
        Tuples.addElement(RowVal);
        RowVal = new byte[][]{this.s2b("BIGINT"), Integer.toString(-5).getBytes(), this.s2b("19"), this.s2b(""), this.s2b(""), this.s2b("(M) UNSIGNED ZEROFILL"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("true"), this.s2b("false"), this.s2b("true"), this.s2b("BIGINT"), this.s2b("0"), this.s2b("0"), this.s2b(""), this.s2b(""), this.s2b("10")};
        Tuples.addElement(RowVal);
        RowVal = new byte[][]{this.s2b("MEDIUMBLOB"), Integer.toString(-4).getBytes(), this.s2b("16777215"), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("true"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("MEDIUMBLOB"), this.s2b("0"), this.s2b("0"), this.s2b(""), this.s2b(""), this.s2b("10")};
        Tuples.addElement(RowVal);
        RowVal = new byte[][]{this.s2b("LONGBLOB"), Integer.toString(-4).getBytes(), Integer.toString(Integer.MAX_VALUE).getBytes(), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("true"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("LONGBLOB"), this.s2b("0"), this.s2b("0"), this.s2b(""), this.s2b(""), this.s2b("10")};
        Tuples.addElement(RowVal);
        RowVal = new byte[][]{this.s2b("BLOB"), Integer.toString(-4).getBytes(), this.s2b("65535"), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("true"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("BLOB"), this.s2b("0"), this.s2b("0"), this.s2b(""), this.s2b(""), this.s2b("10")};
        Tuples.addElement(RowVal);
        RowVal = new byte[][]{this.s2b("TINYBLOB"), Integer.toString(-3).getBytes(), this.s2b("255"), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("true"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("TINYBLOB"), this.s2b("0"), this.s2b("0"), this.s2b(""), this.s2b(""), this.s2b("10")};
        Tuples.addElement(RowVal);
        RowVal = new byte[][]{this.s2b("CHAR"), Integer.toString(1).getBytes(), this.s2b("255"), this.s2b("'"), this.s2b("'"), this.s2b("(M) [BINARY]"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("CHAR"), this.s2b("0"), this.s2b("0"), this.s2b(""), this.s2b(""), this.s2b("10")};
        Tuples.addElement(RowVal);
        RowVal = new byte[][]{this.s2b("NUMERIC"), Integer.toString(2).getBytes(), this.s2b("17"), this.s2b(""), this.s2b(""), this.s2b("(M,D)"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("true"), this.s2b("NUMERIC"), this.s2b("308"), this.s2b("308"), this.s2b(""), this.s2b(""), this.s2b("10")};
        Tuples.addElement(RowVal);
        RowVal = new byte[][]{this.s2b("DECIMAL"), Integer.toString(3).getBytes(), this.s2b("17"), this.s2b(""), this.s2b(""), this.s2b("(M,D)"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("true"), this.s2b("DECIMAL"), this.s2b("-308"), this.s2b("308"), this.s2b(""), this.s2b(""), this.s2b("10")};
        Tuples.addElement(RowVal);
        RowVal = new byte[][]{this.s2b("INT"), Integer.toString(4).getBytes(), this.s2b("10"), this.s2b(""), this.s2b(""), this.s2b("(M) UNSIGNED ZEROFILL"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("true"), this.s2b("false"), this.s2b("true"), this.s2b("INT"), this.s2b("0"), this.s2b("0"), this.s2b(""), this.s2b(""), this.s2b("10")};
        Tuples.addElement(RowVal);
        RowVal = new byte[][]{this.s2b("MEDIUMINT"), Integer.toString(4).getBytes(), this.s2b("7"), this.s2b(""), this.s2b(""), this.s2b("(M) UNSIGNED ZEROFILL"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("true"), this.s2b("false"), this.s2b("true"), this.s2b("MEDIUMINT"), this.s2b("0"), this.s2b("0"), this.s2b(""), this.s2b(""), this.s2b("10")};
        Tuples.addElement(RowVal);
        RowVal = new byte[][]{this.s2b("SMALLINT"), Integer.toString(5).getBytes(), this.s2b("5"), this.s2b(""), this.s2b(""), this.s2b("(M) UNSIGNED ZEROFILL"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("true"), this.s2b("false"), this.s2b("true"), this.s2b("SMALLINT"), this.s2b("0"), this.s2b("0"), this.s2b(""), this.s2b(""), this.s2b("10")};
        Tuples.addElement(RowVal);
        RowVal = new byte[][]{this.s2b("FLOAT"), Integer.toString(6).getBytes(), this.s2b("10"), this.s2b(""), this.s2b(""), this.s2b("(M,D)"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("true"), this.s2b("FLOAT"), this.s2b("-38"), this.s2b("38"), this.s2b(""), this.s2b(""), this.s2b("10")};
        Tuples.addElement(RowVal);
        RowVal = new byte[][]{this.s2b("DOUBLE"), Integer.toString(8).getBytes(), this.s2b("17"), this.s2b(""), this.s2b(""), this.s2b("(M,D)"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("true"), this.s2b("DOUBLE"), this.s2b("-308"), this.s2b("308"), this.s2b(""), this.s2b(""), this.s2b("10")};
        Tuples.addElement(RowVal);
        RowVal = new byte[][]{this.s2b("DOUBLE PRECISION"), Integer.toString(8).getBytes(), this.s2b("17"), this.s2b(""), this.s2b(""), this.s2b("(M,D)"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("true"), this.s2b("DOUBLE PRECISION"), this.s2b("-308"), this.s2b("308"), this.s2b(""), this.s2b(""), this.s2b("10")};
        Tuples.addElement(RowVal);
        RowVal = new byte[][]{this.s2b("REAL"), Integer.toString(8).getBytes(), this.s2b("17"), this.s2b(""), this.s2b(""), this.s2b("(M,D)"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("true"), this.s2b("REAL"), this.s2b("-308"), this.s2b("308"), this.s2b(""), this.s2b(""), this.s2b("10")};
        Tuples.addElement(RowVal);
        RowVal = new byte[][]{this.s2b("VARCHAR"), Integer.toString(12).getBytes(), this.s2b("255"), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("VARCHAR"), this.s2b("0"), this.s2b("0"), this.s2b(""), this.s2b(""), this.s2b("10")};
        Tuples.addElement(RowVal);
        RowVal = new byte[][]{this.s2b("DATE"), Integer.toString(91).getBytes(), this.s2b("0"), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("DATE"), this.s2b("0"), this.s2b("0"), this.s2b(""), this.s2b(""), this.s2b("10")};
        Tuples.addElement(RowVal);
        RowVal = new byte[][]{this.s2b("TIME"), Integer.toString(92).getBytes(), this.s2b("0"), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("TIME"), this.s2b("0"), this.s2b("0"), this.s2b(""), this.s2b(""), this.s2b("10")};
        Tuples.addElement(RowVal);
        RowVal = new byte[][]{this.s2b("DATETIME"), Integer.toString(93).getBytes(), this.s2b("0"), this.s2b("'"), this.s2b("'"), this.s2b("(M)"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("DATETIME"), this.s2b("0"), this.s2b("0"), this.s2b(""), this.s2b(""), this.s2b("10")};
        Tuples.addElement(RowVal);
        RowVal = new byte[][]{this.s2b("TIMESTAMP"), Integer.toString(93).getBytes(), this.s2b("0"), this.s2b("'"), this.s2b("'"), this.s2b("(M)"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("TIMESTAMP"), this.s2b("0"), this.s2b("0"), this.s2b(""), this.s2b(""), this.s2b("10")};
        Tuples.addElement(RowVal);
        return new ResultSet(Fields, Tuples, this._Conn);
    }

    public java.sql.ResultSet getIndexInfo(String Catalog, String Schema, String Table, boolean unique, boolean approximate) throws SQLException {
        String DB_Sub = "";
        if (Catalog != null) {
            if (!Catalog.equals("")) {
                DB_Sub = " FROM " + Catalog;
            }
        } else {
            DB_Sub = " FROM " + this._Database;
        }
        ResultSet RS = this._Conn.execSQL("SHOW INDEX FROM " + Table + DB_Sub, -1);
        RS.setConnection(this._Conn);
        Field[] Fields = new Field[]{new Field("", "TABLE_CAT", 1, 255), new Field("", "TABLE_SCHEM", 1, 0), new Field("", "TABLE_NAME", 1, 255), new Field("", "NON_UNIQUE", 1, 3), new Field("", "INDEX_QUALIFIER", 1, 1), new Field("", "INDEX_NAME", 1, 32), new Field("", "TYPE", 1, 32), new Field("", "ORDINAL_POSITION", 5, 5), new Field("", "COLUMN_NAME", 1, 32), new Field("", "ASC_OR_DESC", 1, 1), new Field("", "CARDINALITY", 1, 32), new Field("", "PAGES", 4, 10), new Field("", "FILTER_CONDITION", 1, 32)};
        Vector<byte[][]> Tuples = new Vector<byte[][]>();
        while (RS.next()) {
            byte[][] Tuple = new byte[14][];
            Tuple[0] = Catalog == null ? new byte[]{} : Catalog.getBytes();
            Tuple[1] = new byte[0];
            Tuple[2] = RS.getBytes("Table");
            Tuple[3] = RS.getInt("Non_unique") != 0 ? this.s2b("true") : this.s2b("false");
            Tuple[4] = new byte[0];
            Tuple[5] = RS.getBytes("Key_name");
            Tuple[6] = Integer.toString(3).getBytes();
            Tuple[7] = RS.getBytes("Seq_in_index");
            Tuple[8] = RS.getBytes("Column_name");
            Tuple[9] = RS.getBytes("Collation");
            Tuple[10] = RS.getBytes("Cardinality");
            Tuple[11] = new byte[0];
            Tuple[12] = new byte[0];
            Tuples.addElement(Tuple);
        }
        ResultSet Results = new ResultSet(Fields, Tuples, this._Conn);
        return Results;
    }

    private byte[] s2b(String S) {
        return S.getBytes();
    }
}

