package com.mwc.util;

import java.util.*;

/**
 * A hashtable sub-class of the 
 * java.util.Dictionary class...
 * 
 * @author Matthew W. Coan (4:26 AM 11/23/2002)
 */
public class MWCHashtable extends Dictionary {
   /**
    * List of prime number hash table sizes.
    */
   public static final int primeArray[] = {
     53,         97,         193,       389,       769,
     1543,       3079,       6151,      12289,     24593,
     49157,      98317,      196613,    393241,    786433,
     1572869,    3145739,    6291469,   12582917,  25165843,
     50331653,   100663319,  201326611, 402653189, 805306457,
     1610612741
   };

   /**
    * Default size
    */
   public static final int DEFAULT_SIZE = primeArray[0];
   
   private LinkedList _tbl[];
   private int _size;

   // Interanl associaton class just for hash table
   private class Association {
      Object key;
      Object value;
      int hashCode;
      
      Association(Object key, Object value, int hashCode) {
         this.key = key;
         this.value = value;
         this.hashCode = hashCode;
      }
      
      Object setValue(Object value) {
         Object temp = this.value;
         this.value = value;
         return temp;
      }
   }
   
   public MWCHashtable(int size) {
      Assert.checkArg("Hashtable size must be greater then zero!",
                      size > 0);
      _tbl = new LinkedList[size];
      _size = 0;
   }
   
   public MWCHashtable() {
      this(DEFAULT_SIZE);
   }
   
   public static int findNextHashSize(int size) {
      for(int i = 0; i < primeArray.length; i++) {
         if(primeArray[i] > size)
            return primeArray[i];
      }
      return primeArray[primeArray.length - 1];
   }

   public Object put(Object key, Object value) {
      int hashCode = Math.abs(key.hashCode());
      int index = hashCode % _tbl.length;
      LinkedList l = _tbl[index];
      Association association;
      if(l != null) { 
         for(Iterator it = l.iterator(); it.hasNext();) {
            association = (Association)it.next();
            if(key.equals(association.key))
               return association.setValue(value);
         }
         association = new Association(key, value, hashCode);
         l.add(association);
      }
      else {
         l = new LinkedList();
         association = new Association(key, value, hashCode);
         l.add(association);
         _tbl[index] = l;
      }
      _size++;
      
      // re-hash
      if(_size > _tbl.length) {
         int tblSize = _size;
         tblSize = findNextHashSize(_size);
         LinkedList tempTable[] = new LinkedList[tblSize];
         for(int i = 0; i < _tbl.length; i++) {
            for(Iterator it = _tbl[i].iterator(); it.hasNext();) {
               association = (Association)it.next();
               index = association.hashCode % tempTable.length;
               l = (LinkedList)_tbl[index];
               if(l == null) {
                  l = new LinkedList();
                  tempTable[index] = l;
               }
               l.add(association);
            }
         }
         _tbl = tempTable;
      }
      
      return null;
   }
   
   public Object remove(Object key) {
      LinkedList l = _tbl[Math.abs(key.hashCode()) % _tbl.length];
      if(l == null)
         return null;
      Association association;
      for(Iterator it = l.iterator(); it.hasNext();) {
         association = (Association)it.next();
         if(key.equals(association.key)) {
            it.remove();
            _size--;
            return association.value;
         }
      }
      return null;
   }
   
   public Object get(Object key) {
      Assert.checkArg("Key must not equal null!", key != null);
      LinkedList l = _tbl[Math.abs(key.hashCode()) % _tbl.length];
      if(l == null)
         return null;
      Association association;
      for(Iterator it = l.iterator(); it.hasNext();) {
         association = (Association)it.next();
         if(key.equals(association.key))
            return association.value;
      }
      return null;
   }
   
   public boolean isEmpty() {
      return ((_size == 0)?(true):(false));
   }
   
   public int size() {
      return _size;
   }
   
   public Enumeration keys() {
      Vector keyVec = new Vector(_size);
      for(int i = 0; i < _tbl.length; i++) {
         if(_tbl[i] != null) {
            for(Iterator it = _tbl[i].iterator(); it.hasNext();)
               keyVec.addElement(((Association)it.next()).key);
         }
      }
      return keyVec.elements();
   }
   
   public Enumeration elements() {
      Vector keyVec = new Vector(_size);
      for(int i = 0; i < _tbl.length; i++) {
         if(_tbl[i] != null) {
            for(Iterator it = _tbl[i].iterator(); it.hasNext();)
               keyVec.addElement(((Association)it.next()).value);
         }
      }
      return keyVec.elements();
   }
   
   public static void main(String args[]) {
      int size = (int)(Math.abs(Math.round(Math.random() * 10000.0)) % 50) + 1;
      int tblSize = 1 + (size + (int)Math.round(size * 0.2));
      MWCHashtable hash = new MWCHashtable(tblSize);
      long rand;
      for(int i = 0; i < 30; i++) {
         rand = (int)Math.round(Math.random() * 1000.0);
         hash.put(new Long(rand), new Long(rand));
      }
      
      Enumeration keys = hash.keys();
      Enumeration elements = hash.elements();
      Long key, value;
      while(keys.hasMoreElements() 
            && elements.hasMoreElements()) {
         key = (Long)keys.nextElement();
         value = (Long)elements.nextElement();
         if(!key.equals(value)) {
            System.out.println("WE HAVE A PROBLME @ LOCATION #1");
            System.exit(1);
         }
         value = (Long)hash.get(key);
         if(value == null || !value.equals(key)) {
            System.out.println("WE HAVE A PROBLME @ LOCATION #2");
            System.exit(1);
         }
      }

      System.out.println("Distribution in hashtable:");
      for(int i = 0; i < hash._tbl.length; i++)
         System.out.println("hash._tbl["+i+"]="
                            +((hash._tbl[i] == null)
                              ?("null")
                               :(hash._tbl[i].size()+"")));
      
      keys = hash.keys();
      while(keys.hasMoreElements())
         hash.remove(keys.nextElement());
      
      if(hash.size() != 0) {
         System.out.println("WE HAVE A PROBLME @ LOCATION #3");
         System.exit(1);
      }
      
      keys = hash.keys();
      while(keys.hasMoreElements())
         System.out.println("key="+keys.nextElement().toString());
      
      elements = hash.elements();
      while(elements.hasMoreElements()) 
         System.out.println("elements="+elements.nextElement().toString());
      
      System.out.println("TEST FINISHED");
   }
}
