#ifndef _LOCK_FILE_H
#define _LOCK_FILE_H

#include <fcntl.h>
#include <string>

namespace file_tools {

using namespace std;

class LockFile {
   int fd;
   const char * file_name;
   string temp;

public:
   LockFile(const char * fn) 
   {
      file_name = fn;
      fd = open(fn, O_EXCL | O_RDWR);
   }

   LockFile(const string & fn) 
   {
      temp = fn;
      file_name = temp.c_str();
      fd = open(file_name, O_EXCL | O_RDWR);
   }

   ~LockFile()
   {
      close(fd);
   }

   void read_lock();
   void read_unlock();
   void write_lock();
   void write_unlock();
   operator void*() { return ((void*)(fd > 0)); }
};

inline
void
LockFile::read_lock()
{
   flock(fd, LOCK_SH);
}

inline
void
LockFile::read_unlock()
{
   flock(fd, LOCK_UN);
}

inline
void
LockFile::write_lock()
{
   flock(fd, LOCK_EX);
}

inline
void
LockFile::write_unlock()
{
   flock(fd, LOCK_UN);
}

}

#endif
