#ifndef _TCP_SERVER_H
#define _TCP_SERVER_H
/*

tcp_server class.

Author: Matthew William Coan
Date: Tue Jul 27 15:44:40 EDT 2010

*/

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <unistd.h>

#include <cstring>

#define closesocket(a) close(a)
#define SOCKET int

namespace net_tools {

using namespace std;

class tcp_server {
   const char * _ip_address;
   const int _port;
   sockaddr_in _svr, _cli;
   SOCKET _fd, _client_fd;

public:
   tcp_server(const char * ip_address, 
              const int port);
   ~tcp_server();

   int accept();
   void close();
   const char * get_ip() {
      return inet_ntoa(_svr.sin_addr);
   }
   sockaddr_in * get_addr() {
      return &_cli;
   }
};

}

#endif /* _TCP_SERVER_H */

