#include <iostream>
#include <string>
#include <cctype>
#include "tcp_server.h"
#include "tcp_stream.h"

using namespace std;
using namespace net_tools;

int
System(const string & cmd)
{
   cout << "SYSTEM: " << cmd << endl;
   return system(cmd.c_str());
}

string
read_line(tcp_stream & in)
{
   string ret;
   char ch;
   ch = in.get();
   while(ch != '\n' && ch != '\r') {
      if(ret.size() >= 1000) 
         break;
      ret += ch;
      ch = in.get();
   }
   return ret;
}

string
escape(const string & str)
{
   string ret;
   for(size_t i = 0; i < str.size(); i++) {
      if(isalnum(str[i]) || isspace(str[i])) {
         ret += str[i];
      }
   }
   return ret;
}

int
main()
{
   string text;

   tcp_server svr("0.0.0.0", 2013);
 
   while(true) {
      cout << "run..." << endl;

      tcp_stream st = svr.accept();

      text = read_line(st);

      cout << "text: " << text << endl;

      st.close();

      System(string("echo \"(SayText \\\"") + escape(text) + string("\\\")\" | /usr/bin/festival"));
   }

   return 0;
}
