#include <sys/types.h>
#include <signal.h>

#include "worm_httpd.h"

/*

Author: Matthew William Coan
Date: Wed May 22 14:36:37 EDT 2013

*/

using namespace worm;

worm_httpd * p_httpd = 0;

void
on_signal(int arg) 
{
   switch(arg) {
   case SIGINT:
   case SIGTERM:
   case SIGHUP:
      p_httpd->shutdown();
      cout << "done..." << endl;
      exit(0);
   break;

   case SIGCHLD:
   break;
   }
}

int
main(int argc, char ** argv, char ** envp)
{
   try {
      bool init = false;

      for(int i = 0; i < argc; i++) {
         if(strcmp(argv[i], "-daemon") == 0) {
            init = true;
         }
      }

      if(init)
         daemon(1, 1);

      chdir(HOME_DIR);

      signal(SIGINT, on_signal);
      signal(SIGTERM, on_signal);
      signal(SIGHUP, on_signal);
      signal(SIGCHLD, on_signal);

      worm_httpd httpd("0.0.0.0", 80);

      p_httpd = &httpd;

      httpd.run();
   }
   catch(...) {
      cerr << "error..." << endl;
      exit(1);
   }
   return 0;
}
