/*

(C) Copywrite 2008.  All rights reserved.
Matthew William Coan.

String functions...

Author: Matthew William Coan
Date: Thu Jan  1 19:20:33 EST 2009

*/

#ifndef _STR_H
#define _STR_H

#include <string>
#include <cstring>

using namespace std;


inline
string 
get_proto(const string & url)
{
   string proto;

   for(int i = 0; i < url.size(); i++) {
      if(url[i] == ':') {
         break;
      }

      proto += url[i];
   }

   return proto;
}

inline
   string
   get_domain_name(const string & url)
   {
      string domain_name;

      int i;

      for(i = 0; i < url.size(); i++) {
         if(url[i] == ':') {
            i++;

            if(i < url.size()) {
               if(url[i] == '/') {
                  i++;

                  if(i < url.size()) {
                     if(url[i] == '/') {
                        i++;

                        while(i < url.size()) {
                           if((url[i] == ':') || (url[i] == '/')) {
                              break;
                           }

                           domain_name += url[i];

                           i++;
                        }

                        break;
                     }
                  }
               }

               domain_name += url[i];

               i++;
            }

            break;
         }
      }

      return domain_name;
   }

inline
   int
   get_port(const string & url)
   {
      int port = 80;
      string temp;
      size_t i;

      for(i = 7; i < url.size(); i++) {
         if(url[i] == ':') {
            i++;

            while(i < url.size()) {
               if(!isdigit(url[i])) {
                  break;
               }

               temp += url[i];

               i++;
            }

            break;
         }
      }

      port = atoi(temp.c_str());

      if(port <= 0) {
         port = 80;
      }

      return port;
   }

inline
   string
   get_URI(const string & url)
   {
      string uri;
      size_t i;

      for(i = 7; i < url.size(); i++) {
          if(url[i] == '/') {
             break;
          }
      }

      while(i < url.size()) {
         if(url[i] == '?') {
            break;
         }

         uri += url[i];

         i++;
      }

//cout << "URI=\"" << uri << "\"" << endl << flush;

      return uri;
   }


inline
   string
   get_query_string(const string & url)
   {
      string query_string;

      for(int i = 0; i < url.size(); i++) {
         if(url[i] == '?') {
            for(i++; i < url.size(); i++) {
               query_string += url[i];
            }

            break;
         }
      }

      return query_string;
   }

inline
   bool
   is_ip_address(const string & str)
   {
      bool ret = true;

      for(size_t i = 0; i < str.size(); i++) {
         if(isalpha(str[i])) {
            ret = false;

            break;
         }
      }

      return ret;
   }

inline
bool
ends_with(const string & str, 
          const string & end)
{
   bool ret = false;

   if(str.size() >= end.size()) {
      register int j = 0;
      register int i;

      for(i = (str.size() - end.size()) - 1; 
          (i >= 0) && (i < str.size()) && (j < end.size());
          i++, j++) {

         if(str[i] == end[j]) {
            ret = true;
         } 
         else {
            ret = false;
            break;
         }
      }
   }

   return ret;
}

inline
string
to_string(const int arg)
{
   const size_t MAX = (1024);

   char buf[MAX];

   memset(buf, 0, MAX);

   sprintf(buf, "%d", arg);

   string ret(buf);

   return ret;
}

#endif /* _STR_H */
