#include "tcp_stream.h"
#include <errno.h>
#include <sys/select.h>
#include <fcntl.h>

using namespace std;
using namespace net_tools;

static const size_t IO_BUFFER_SIZE = 1024;

#define SLEEP_TIME 3

tcp_stream::tcp_stream(int fd)
{
   _open = true;

   _error = false;

   _fd = fd;

   memset(_buffer, 0, IO_BUFFER_SIZE);

   _ip_address = "";

   _port = 0;
}

void
connect_alarm(int the_signal)
{
   if(the_signal == SIGALRM) {

   }
}

tcp_stream::tcp_stream(const char * ip_address, 
                       const int port)
{
   if(ip_address == NULL) {
      _error = true;
      return;
   }

   if(strlen(ip_address) == 0) {
      _error = true;
      return;
   }

//cout << "domain_name: \"" << ip_address << "\"" << endl << flush;
   typedef void (*signal_function_type)(int);

   signal_function_type sigfunc;

   sigfunc = signal(SIGALRM, connect_alarm);

   alarm(SLEEP_TIME);

   hostent * p_host = gethostbyname(ip_address);

   alarm(0);

   signal(SIGALRM, sigfunc);

   if(p_host != NULL) {
      ip_address =  inet_ntoa(*(in_addr*)(p_host->h_addr));
   }

   _error = false;

   if(ip_address == NULL) {
      _error = true;
      return;
   }

//cout << "ip_address: " << ip_address << endl << flush;

   _open = true;

   _fd = 0;

   memset(_buffer, 0, IO_BUFFER_SIZE);

   _ip_address = ip_address;

   _port = port;

   //sockaddr_in sock_data;

   memset((char*)(&sock_data), 0, sizeof(sock_data));

   if(p_host != NULL) {
      if(p_host->h_addr == NULL) {
         _error = true;
         return;
      }
      sock_data.sin_family = AF_INET;
      bcopy(p_host->h_addr, &(sock_data.sin_addr.s_addr), p_host->h_length);
      sock_data.sin_port = htons(_port);

      if((_fd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
         _error = true;
         return;
      }

      timeval timeout;

      timeout.tv_sec = SLEEP_TIME;

      setsockopt(_fd, SOL_SOCKET, SO_SNDTIMEO, (char *)&timeout, sizeof(timeout));

      setsockopt(_fd, SOL_SOCKET, SO_RCVTIMEO, (char *)&timeout, sizeof(timeout));

      sigfunc = signal(SIGALRM, connect_alarm);

      alarm(SLEEP_TIME);

      size_t sz = sizeof(sock_data);

      if(connect(_fd, (sockaddr*)(&sock_data), sz) < 0) {
         _error = true;
      }

      alarm(0);

      signal(SIGALRM, sigfunc);
   }
   else {
      _error = true;
   }
}

tcp_stream::~tcp_stream()
{
   if(_open) {
      ::close(_fd);
      _open = false;
   }
}

void tcp_stream::clearerr()
{
   _error = false;

   memset(_buffer, 0, IO_BUFFER_SIZE);
}

tcp_stream::operator void*()
{
   void * p;

   if(_error) {
      p = (void*)(0U);
   }         
   else {
      p = (void*)(1U);
   }

   return p;
}

tcp_stream & tcp_stream::operator<<(int i) 
{
   memset(_buffer, 0, IO_BUFFER_SIZE);

   sprintf(_buffer, "%d", i);

   int sz = strlen(_buffer);

   if(send(_fd, _buffer, sz, 0) != sz) {
      _error = true;
   }

   return *this;
}

tcp_stream & tcp_stream::operator<<(const char * str)
{
   int sz = strlen(str);
   if(send(_fd, str, sz, 0) != sz) {
      _error = true;
   }
   return *this;
}

tcp_stream & tcp_stream::operator<<(const string & str)
{
   if(static_cast< size_t >(send(_fd, str.c_str(), str.size(), 0)) != str.size()) {
      _error = true;
   }
   return *this;
}

tcp_stream & tcp_stream::operator>>(string & str)
{
   char ch;
   str = "";
   int rc;

   while((rc = recv(_fd, &ch, 1, 0)) == 1) {
      if(isspace(ch)) {
         break;
      }
      str += ch;
   }

   if(rc < 0) {
      _error = true;
   }

   return *this;
}

tcp_stream & tcp_stream::operator>>(int & i)
{
   char ch;

   if(recv(_fd, &ch, 1, 0) != 1) {
      _error = true;
   }

   while(isspace(ch)) {
      if(recv(_fd, &ch, 1, 0) != 1) {
         _error = true;
      }
   }   

   string temp;

   while(isdigit(ch)) {
      temp += ch;
 
      if(recv(_fd, &ch, 1, 0) != 1) {
         _error = true;
      }
   }

   i = atoi(temp.c_str());

   return *this;
}

char tcp_stream::get() 
{
   char ch = '\0';

   if(recv(_fd, &ch, 1, 0) != 1) {
      _error = true;
   }

   return ch;
}

void tcp_stream::close() 
{
   if(_open) {
      ::close(_fd);
      _open = false;
   }
}
