/*

    Copyright (C) 2009  Matthew William Coan

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

TCP/IP IOStreams like class.

Use a template member function with a data stream class as the template
type. pipe_stream, iostream, fstream, tcp_stream and others.

Author: Matthew W. Coan
Date: Fri Jun 18 14:04:57 EDT 2010
 
*/

#ifndef _TCP_STREAM_H
#define _TCP_STREAM_H

#include <iostream>
#include <string>

#include <cstdlib>
#include <cstring>

#include <sys/types.h>
#include <sys/socket.h>
#include <signal.h>
#include <unistd.h>

#include <netinet/in.h>
#include <arpa/inet.h>

#include <netdb.h>


namespace net_tools {

using namespace std;

static const size_t IO_BUFFER_SIZE = 1024;

class tcp_stream {
   bool _error;
   int _fd;
   char _buffer[IO_BUFFER_SIZE];
   const char * _ip_address;
   int _port;
   bool _open;
   sockaddr_in sock_data;

public:
   tcp_stream(int fd);

   tcp_stream(const char * ip_address, 
              const int port);

   virtual ~tcp_stream();

   void clearerr();

   operator void*();

   tcp_stream & operator<<(int i);

   tcp_stream & operator<<(const char * str);

   tcp_stream & operator<<(const string & str);

   tcp_stream & operator>>(string & str);

   tcp_stream & operator>>(int & i);

   char get();

   void close();

   int get_fd() { return _fd; }

   const char * get_ip_address() { return _ip_address; }
};

}

#endif /* _TCP_STREAM_H */
