/*

    Copyright (C) 2009  Matthew William Coan

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.


Simple wget web http client program.

Author: Matthew William Coan
Date: Sun Oct 24 19:00:22 EST 2010

*/
#include <iostream>
#include <string>

#include <signal.h>

#include "tcp_stream.h"

using namespace std;
using namespace net_tools;

#define TIMEOUT_VALUE 3

void
on_SIGALRM(int sig) 
{
   exit(0);
}

string
get_domain(const string & url)
{
   string ret;

   size_t i = 7;

   while(i < url.size()) {
      if(url[i] == '/') {
         break;
      }

      ret += url[i];

      i++;
   }

   return ret;
}

string 
get_URI(const string & url)
{
   string ret;
   bool in_uri = false;

   for(size_t i = 7; i < url.size(); i++) {
      if(url[i] == '/') {
         in_uri = true;
      }

      if(in_uri) {
         ret += url[i];
      }
   }

   if(ret == "") {
      ret = "/";
   }
   
   return ret;
}

int
main(int argc,
     char ** argv,
     char ** envp)
{
   signal(SIGALRM, on_SIGALRM);

   if(argc != 2) {
      cerr << "usage: " << argv[0] << " <URL>" << endl << flush;
      exit(1);
   }

   string url = argv[1];

   string domain = get_domain(url);

   string uri = get_URI(url);

   if(url.find("http://") == string::npos) {
      cerr << "only http:// URLs are allowed" << endl << endl;
      exit(1);
   }

   if(domain.size() && uri.size()) {
      alarm(TIMEOUT_VALUE);

      tcp_stream stream(domain.c_str(), 80);

      if(stream) {
         string request = "GET " + uri + " HTTP/1.0\r\n\r\n";

         stream << request;

         char ch = stream.get();

         while(stream) {
            cout << ch;

            ch = stream.get();
         }

         cout << flush;

         stream.close();
      }

      alarm(0);
   }

   return 0;
}

