/*

C++ demonstration application for the xgui class library.

Author: Matthew W. Coan
Date: Sat May  4 01:47:31 EDT 2013

*/

#include "xgui.h"

using namespace xgui;

class MyWindow : public Frame {
public:
   size_t last_x, last_y;
   MyWindow() 
   : Frame("Matt XWindows Demo...", 640, 480) { 
      last_x = last_y = 0U;
   }

   ~MyWindow() { 

   }

   void on_paint(Graphics & g) {
      cout << "on_paint()" << endl;
      g.set_color(Color(32000,65000,32000));
      g.draw_rect(0,0,width,height);
      g.draw_rect(1,1,width-1,height-1);
      g.draw_rect(2,2,width-2,height-2);
      g.draw_rect(3,3,width-3,height-3);
   }

   void on_mouse_move(const size_t x, const size_t y) {
      cout << "on_mouse_move(" << x << "," << y << ")" << endl;
      g.set_color(Color(32000,65000,32000));
      g.draw_line(last_x,last_y,x,y);
      last_x = x;
      last_y = y;
   }

   void on_click(const size_t x, const size_t y) {
      cout << "on_click(" << x << "," << y << ")" << endl;
      g.set_color(Color(32000,65000,32000));
      char text[100];
      strcpy(text,"X is FUN!");
      g.draw_text(x,y,text);
      g.draw_line(last_x,last_y,x,y);
      last_x = x;
      last_y = y;
   }

   void on_key_press(const char ch) {
      cout << "on_key_press(" << ch << ")" << endl;
   }
  
   void on_resize(const size_t w, 
                  const size_t h) {
      cout << "on_resize(" << w << "," << h << ")" << endl;
      g.set_color(Color(32000,65000,32000));
      Frame::on_resize(w,h);
   }

   void on_close_window() {
      cout << "on_close_window()" << endl;
   }
};

int
main()
{
   MyWindow my_win;
   return my_win.run();
}
