#include "xgui.h"

/* 
	Remember to compile try:
		1) gcc hi.c -o hi -lX11
		2) gcc hi.c -I /usr/include/X11 -L /usr/X11/lib -lX11
		3) gcc hi.c -I /where/ever -L /who/knows/where -l X11

	Brian Hammond 2/9/96.    Feel free to do with this as you will!

XDrawLine(dis,win,gc, x1,y1, x2,y2);
XDrawArc(dis,win,gc,x,y, width, height, arc_start, arc_stop);
XDrawRectangle(dis, win, gc, x, y, width, height)
XFillArc(dis,win, gc, x, y, width, height, arc_start, arc_stop);
XFillRectangle(dis,win,gc, x, y, width, height);
XDrawString(dis,win,gc,x,y, string, strlen(string));

*/



/* include some silly stuff */
#include <iostream>
#include <stdio.h>
#include <stdlib.h>

using namespace std;

/* here are our X variables */



int
xgui::Frame::xgui_run () 
{
	XEvent event;		/* the XEvent declaration !!! */
	KeySym key;		/* a dealie-bob to handle KeyPress Events */	
        char text[100];

	p_dis = 0;

	init_x();

	while(1) {		
		XNextEvent(p_dis, &event);
	
		if (event.type == Expose && event.xexpose.count == 0) {
			redraw();
                        int width = event.xexpose.width;
                        int height = event.xexpose.height;
			on_resize(width,height);
                        on_paint(g);
		}
		if (event.type == KeyPress &&
			XLookupString(&event.xkey,text,255,&key,0) == 1) {
			on_key_press(text[0]);
		}
		if (event.type == ButtonPress) {
			int x = event.xbutton.x,
			    y = event.xbutton.y;
                        on_click(x,y);
		}
		if(event.type == MotionNotify) {
			on_mouse_move(event.xmotion.x,
					event.xmotion.y);
		}
		if(event.type == DestroyNotify) {
			on_close_window();
		}
	}

	return 0;
}

void xgui::Frame::init_x() 
{
/* get the colors black and white (see section for details) */        
	unsigned long black,white;

	p_dis=XOpenDisplay((char *)0);
   	screen=DefaultScreen(p_dis);
        colormap = DefaultColormap(p_dis,screen);
	black=BlackPixel(p_dis,screen),
	white=WhitePixel(p_dis, screen);
   	win=XCreateSimpleWindow(p_dis,DefaultRootWindow(p_dis),0,0,	
		width, height, 5,black, white);
	XSetStandardProperties(p_dis,win,title.c_str(),title.c_str(),None,NULL,0,NULL);
	XSelectInput(p_dis, win, ExposureMask|ButtonPressMask|KeyPressMask|PointerMotionMask);
/*
xAttributes.event_mask =  ExposureMask | KeyPressMask | ButtonPress |
                          StructureNotifyMask | ButtonReleaseMask |
                          KeyReleaseMask | EnterWindowMask | LeaveWindowMask |
                          PointerMotionMask | Button1MotionMask | VisibilityChangeMask |
                          ColormapChangeMask;
*/
        GC gc=XCreateGC(p_dis, win, 0,0);        
        g.set_gc(gc);
        g.set_display(p_dis);
        g.set_window(win);
        g.set_screen(screen);
        g.set_colormap(colormap);
        XSetBackground(p_dis,gc,black);
        XSetForeground(p_dis,gc,white);
/*
	XSetBackground(p_dis,g.get_gc(),white);
	XSetForeground(p_dis,g.get_gc(),black);
*/
	XClearWindow(p_dis, win);
	XMapRaised(p_dis, win);
}

void xgui::Frame::close_x() 
{
	XFreeGC(p_dis, g.get_gc());
	XDestroyWindow(p_dis,win);
	XCloseDisplay(p_dis);	
	exit(1);				
}

void xgui::Frame::redraw() 
{
	XClearWindow(p_dis, win);
}
