#ifndef _XGUI_H
#define _XGUI_H

/*

xgui.h -- simple GUI class libarary for x-windows.

Author: Matthew W. Coan
Date: Fri May  3 18:05:03 EDT 2013

*/

#include <string>
#include <vector>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>

#include <cstring>
#include <cstdlib>

namespace xgui {

using namespace std;

class Color;
class Font;
class Frame;
class Win;
class Button;
class TextBox;
class Label;
class ProgressBar;
class CheckBox;

class Color {
   int red, green, blue;
public:
   Color() { 
      red = 0; 
      green = 0; 
      blue = 0; 
   }
   Color(const int red, const int green, const int blue) {
      this->red = red;
      this->green = green;
      this->blue = blue;
   }
   Color(const Color & c) {
      this->red = c.red;
      this->green = c.green;
      this->blue = c.blue;
   }
   Color & operator=(const Color & c) {
      red = c.red;
      blue = c.blue; 
      green = c.green;
      return *this;
   }
   void set_red(int red) { this->red = red; }
   void set_green(int green) { this->green = green; }
   void set_blue(int blue) { this->blue = blue; }
   int get_red() { return red; }
   int get_green() { return green; }
   int get_blue() { return blue; }
};

class Font {
   string name;
   size_t size;
   size_t width;
   size_t height;
public:
   Font(const Font & f) { size = f.size; width = f.width; height = f.height; }
   Font(const string name = "Times New Roman", const size_t size = 12) { 
      this->name = name;
      this->size = size;
   }
   Font & operator=(const Font & cp) { 
      name = cp.name;
      size = cp.size;
      width = cp.width;
      height = cp.height;
      return *this;
   }
   void set_name(const string & name) { this->name = name; }
   void set_size(const size_t size) { this->size = size; }
   void set_width(const size_t width) { this->width = width; }
   void set_height(const size_t height) { this->height = height; }
};

typedef vector< Win* > window_vector_type;

class Graphics {
   Display * p_dis;
   Window * p_win;
   Colormap colormap;
   GC gc;
   Color color;
   XColor xcolor;
   Font font;
   int screen;

public:
   Graphics() { 
   }

   virtual ~Graphics() { 
   }

   void set_colormap(Colormap colormap) { this->colormap = colormap; }

   void draw_line(const size_t x1, const size_t y1, const size_t x2, const size_t y2) {
      XSetForeground(p_dis,gc,xcolor.pixel);
      XDrawLine(p_dis,*p_win,gc,x1,y1,x2,y2);
   }

   void draw_rect(const size_t x, const size_t y, const size_t w, const size_t h) { 
      XSetForeground(p_dis,gc,xcolor.pixel);
      XDrawRectangle(p_dis,*p_win,gc,x,y,w,h);
   }

   void fill_rect(const size_t x, const size_t y, const size_t w, const size_t h) { 
      XSetForeground(p_dis,gc,xcolor.pixel);
      XFillRectangle(p_dis,*p_win,gc,x,y,w,h);
   }

   void draw_text(const size_t x, const size_t y, const string & text) {
      XSetForeground(p_dis,gc,xcolor.pixel);
      XDrawString(p_dis,*p_win,gc,x,y,text.c_str(),text.size());
   }

   void set_gc(GC & gc) { 
      this->gc = gc; 
   }

   void set_window(Window & win) {
      p_win = &win;
   }

   void set_display(Display * dis) {
      p_dis = dis;
   }
 
   void set_screen(const int screen) { this->screen = screen; }

   GC & get_gc() { return gc; }

   Display * get_display() { return p_dis; }

   Window & get_window() { return *p_win; }

   int get_screen() { return screen; }

   void set_color(const Color c) { 
      color = c;
      xcolor.red = color.get_red();
      xcolor.green = color.get_green();
      xcolor.blue = color.get_blue();
      xcolor.flags = DoRed | DoGreen | DoBlue;
      XAllocColor(p_dis,colormap,&xcolor);
      XSetForeground(p_dis,gc,xcolor.pixel);
   }

   void set_font(Font & f) { 
      font = f;
   }
};

typedef vector< Win* > window_vector_type;

class Win {
   size_t x,y;
   size_t width,height;
public:
   Win(const size_t x, 
        const size_t w,
        const size_t width,
        const size_t height) { 
      this->x = x;
      this->y = y;
      this->width = width;
      this->height = height;
   }

   virtual ~Win() { 
   }

   virtual void on_pait(Graphics & g) {
   }

   virtual void on_click(const size_t x,
                         const size_t y) {
   }

   virtual void on_mouse_move(const size_t x, 
                              const size_t y) {
   }

   virtual void on_key_press(const char ch) {
   }

   virtual void on_resize(const size_t width, 
                          const size_t height) {
   }
};

class Frame {
protected:
   size_t width,height;
   Color bg;
   Color fg;
   Font font;
   string title;
   window_vector_type window_vec;
   Display * p_dis;
   Window win;
   int screen;
   Colormap colormap;
   Graphics g;

   void init_x();
   void close_x();
   void redraw();

public:
   Frame(const string & t, 
         const size_t w, 
         const size_t h) 
   :title(t) {  
      this->width = w;
      this->height= h;
   }

   virtual ~Frame() { 
   }

   virtual void on_paint(Graphics & g) { }
   virtual void on_close_window() { }
   virtual void on_click(const size_t x, const size_t y) { }
   virtual void on_mouse_move(const size_t x, const size_t y) { }
   virtual void on_key_press(const char ch) { }
   virtual void on_resize(const size_t w, const size_t h) { 
      this->width = w;
      this->height = h;
   }
   int xgui_run();
   void add_window(Win & win);
   virtual int run() {
      int rc = xgui_run();
      return rc;
   }
   void set_bg(const Color & c) { bg = c; }
   void set_fg(const Color & c) { fg = c; }
};

class Button : public Win {
   string label;
public:
   void on_paint(Graphics & g) { }
   void on_click(const size_t x, const size_t y) { }
   void on_mouse_over(const size_t x, const size_t y) { }
};

class TextBox : public Win {
   string text;
public:
   void on_paint(Graphics & g) { }
   void on_click(const size_t x, const size_t y) { }
   void on_mouse_over(const size_t x, const size_t y) { }
};

class Label : public Win {
   string text;
public:
   void on_paint(Graphics & g) { }
   void on_click(const size_t x, const size_t y) { }
   void on_mouse_over(const size_t x, const size_t y) { }
};


class MenuItem : public Win {
   string name;
public:
   void on_paint(Graphics & g) { }
   void on_click(const size_t x, const size_t y) { }
   void on_mouse_over(const size_t x, const size_t y) { }
};

typedef vector< MenuItem* > menu_item_vector_type;

class Menu : public Win {
   string name;
   menu_item_vector_type menu_vec;
public:
   void on_paint(Graphics & g) { }
   void on_click(const size_t x, const size_t y) { }
   void on_mouse_over(const size_t x, const size_t y) { }
};

typedef vector< Menu* > menu_vector_type;

class MenuBar : public Win {
   menu_vector_type menu_vec;
public:
   void on_paint(Graphics & g) { }
   void on_click(const size_t x, const size_t y) { }
   void on_mouse_over(const size_t x, const size_t y) { }
};

class StatusBar : public Win {
public:
   void on_paint(Graphics & g) { }
   void on_click(const size_t x, const size_t y) { }
   void on_mouse_over(const size_t x, const size_t y) { }
};

class TitleBar : public Win {
public:
   void on_paint(Graphics & g) { }
   void on_click(const size_t x, const size_t y) { }
   void on_mouse_over(const size_t x, const size_t y) { }
};

class ScrollBar : public Win {
public:
   void on_paint(Graphics & g) { }
   void on_click(const size_t x, const size_t y) { }
   void on_mouse_over(const size_t x, const size_t y) { }
};

class ProgressBar : public Win {
public:
   void on_paint(Graphics & g) { }
   void on_click(const size_t x, const size_t y) { }
   void on_mouse_over(const size_t x, const size_t y) { }
};

class ListItem : public Win {
public:
   void on_paint(Graphics & g) { }
   void on_click(const size_t x, const size_t y) { }
   void on_mouse_over(const size_t x, const size_t y) { }
};

typedef vector< ListItem* > list_item_vector_type;

class ListBox : public Win {
   list_item_vector_type item_vec;
public:
   void on_paint(Graphics & g) { }
   void on_click(const size_t x, const size_t y) { }
   void on_mouse_over(const size_t x, const size_t y) { }
};

class CheckBox : public Win {
public:
   void on_paint(Graphics & g) { }
   void on_click(const size_t x, const size_t y) { }
   void on_mouse_over(const size_t x, const size_t y) { }
};


}

#endif /* _XGUI_H */
