#include <iostream>
#include <string>

#include "xml.h"

using namespace std;
using namespace xml;

class MyParser : public xml_parser {
public:
   void on_start(const string & tag,
                 const string_map_type & param_map) {
      cout << "on_start: " << tag << endl;
   }

   void on_data(const string & data) {
      cout << "on_data: \"" << data << "\"" << endl;
   }

   void on_end(const string & tag) {
      cout << "on_end: " << tag << endl; 
   }
};

int
main(int argc,
     char ** argv,
     char ** envp)
{
   int ret = 0;

   if(argc != 2) {
      cerr << "usage: " << argv[0] << " <xml-file>" << endl;
      exit(1);
   }

   MyParser the_parser;

   the_parser.parse(argv[1]);

   return ret;
}
