/*

    Copyright (C) 2009  Matthew William Coan

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.


Author: Matthew William Coan
Date: Thu Feb 25 10:02:29 EST 2010

*/

#ifndef _XML_H
#define _XML_H

#include <iostream>
#include <fstream>
#include <string>
#include <map>

#include <cstdlib>
#include <cctype>
#include <cstring>

namespace xml {

using namespace std;

bool
read_line(istream & in, string & line)
{
   bool ret = false;

   return ret;
}

class xml_parser {
public:
   typedef map< string, string > string_map_type;

private:

public:
   xml_parser()
   {
   }

   xml_parser(const xml_parser & cp)
   {
   }

   virtual ~xml_parser()
   {
   }

   xml_parser & operator=(const xml_parser & right)
   {
      return *this;
   }

   virtual void on_start(const string & tag,
                         const string_map_type & param_map)
   {
   }

   virtual void on_data(const string & data)
   {
   }

   virtual void on_end(const string & tag)
   {
   }

   string_map_type to_map(const string & tag)
   {
      string_map_type ret;

      char * buffer = new char [tag.size()+1];

      memset(buffer, 0, tag.size()+1);

      strcpy(buffer, tag.c_str());

      char * ptr, * eq;

      ptr = buffer;

      string name;
      string value;

      while(*ptr != '\0' && !isspace(*ptr)) {
         ptr++;
      }

      while(*ptr != '\0') {
         while(isspace(*ptr) && *ptr != '\0') {
            ptr++;
         }

         while(*ptr != '=' && *ptr != '\0') {
            name  += *ptr;
            ptr++;
         }

         if(*ptr == '=') {
            ptr++;
         }

         if(*ptr == '\"') {
            ptr++;
         }

         while(*ptr != '\"' && *ptr != '\0') {
            value += *ptr;
            ptr++;
         }

         if(*ptr == '\"') {
            ptr++;
         }

         ret[name] = value;

         name = "";
         value = "";
      }

      delete [] buffer;

      return ret;
   }

   string get_name(const string & tag)
   {
      string ret;

      for(size_t i = 0; i < tag.size(); i++) {
         if(isalnum(tag[i]) || tag[i] == '_') {
            ret += tag[i];
         }
         else {
            break;
         }
      }

      return ret; 
   }

   bool parse(const char * filename)
   {
      bool ret = false;
      string tag, data;
      char ch;
      bool in_tag = false;

      ifstream in(filename);

      if(in) {
         ch = in.get();

         while(in) {
            if(ch == '<') {
               in_tag = true;
               ch = in.get();
               continue;
            }
            else if(ch == '>') {
               in_tag = false;
               if(tag.size()) {
                  if(tag[0] == '/') {
                     on_data(data);
                     on_end(tag);
                  }
                  else {
                     on_start(get_name(tag), to_map(tag)); 
                  }
               }
               tag = "";
               data = "";
               ch = in.get();
               continue;
            }
            

            if(in_tag) {
               tag += ch;
            }
            else {
               data += ch;
            }

            ch = in.get();
         }

         in.close();
      }

      return ret;
   }
};

}

#endif /* _XML_H */
